/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.LinkedList;
import jhi.flapjack.analysis.StringFinder;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Marker;

public class FindMarker
extends StringFinder {
    private GTViewSet viewSet;
    private GTView view;
    private boolean searchAllChromosomes;
    private int index = 0;
    private int viewIndex = 0;

    public FindMarker(GTViewSet viewSet, boolean searchAllChromosomes, boolean matchCase, boolean useRegex) {
        super(matchCase, useRegex);
        this.viewSet = viewSet;
        this.searchAllChromosomes = searchAllChromosomes;
        this.viewIndex = searchAllChromosomes ? 0 : viewSet.getViewIndex();
        this.view = viewSet.getView(this.viewIndex);
    }

    public LinkedList<Result> search(String str) {
        LinkedList<Result> results = new LinkedList<Result>();
        int searchCount = 0;
        int max = this.view.markerCount();
        if (this.searchAllChromosomes) {
            max = this.viewSet.countAllMarkers();
        }
        while (searchCount < max) {
            Marker marker;
            if (this.index >= this.view.markerCount()) {
                this.view = this.viewSet.getView(++this.viewIndex);
                this.index = 0;
            }
            if (!(marker = this.view.getMarker(this.index)).dummyMarker() && this.matches(marker.getName(), str)) {
                results.add(new Result(marker, this.view.getChromosomeMap()));
            }
            ++searchCount;
            ++this.index;
        }
        return results;
    }

    public static class Result {
        public Marker marker;
        public ChromosomeMap map;

        Result(Marker marker, ChromosomeMap map) {
            this.marker = marker;
            this.map = map;
        }
    }
}

