/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui.matisse;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RatingsPanel
extends JPanel {
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private JLabel[] stars = new JLabel[5];
    private ImageIcon starOn;
    private ImageIcon starOff;
    private int rating = 0;

    public RatingsPanel() {
        for (int i = 0; i < this.stars.length; ++i) {
            final int index = i + 1;
            this.stars[i] = new JLabel(" * ");
            this.stars[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    RatingsPanel.this.setStars(index);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    RatingsPanel.this.setStars(RatingsPanel.this.rating);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    RatingsPanel.this.setRating(index);
                }
            });
        }
        this.setOpaque(false);
        this.setLayout(new GridLayout(1, 5, 0, 0));
        for (JLabel label : this.stars) {
            this.add(label);
        }
    }

    public int getRating() {
        return this.rating;
    }

    private void setRating(int value) {
        this.rating = value;
        if (this.rating < 0) {
            this.rating = 0;
        }
        if (this.rating > 5) {
            this.rating = 5;
        }
        for (ActionListener al : this.actionListeners) {
            al.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    public void doSetup(int rating, ImageIcon starOn, ImageIcon starOff) {
        this.rating = rating;
        this.starOn = starOn;
        this.starOff = starOff;
        for (JLabel label : this.stars) {
            label.setText("");
        }
        this.setStars(rating);
    }

    private void setStars(int rating) {
        int i;
        for (i = 0; i < rating && i < this.stars.length; ++i) {
            this.stars[i].setIcon(this.starOn);
        }
        for (i = rating; i < this.stars.length; ++i) {
            this.stars[i].setIcon(this.starOff);
        }
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }
}

