/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.util.Locale;
import jhi.flapjack.analysis.CalculateSimilarityMatrix;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.io.SimMatrixExporter;
import jhi.flapjack.io.cmd.CmdOptions;
import jhi.flapjack.io.cmd.CreateProject;
import jhi.flapjack.io.cmd.CreateProjectSettings;
import jhi.flapjack.io.cmd.DataImportSettings;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import scri.commons.gui.RB;
import scri.commons.gui.TaskDialog;

public class CreateMatrix {
    private DataSet dataSet = new DataSet();
    private CreateProjectSettings projectSettings;
    private DataImportSettings importSettings;
    private String filename;

    public static void main(String[] args) {
        CmdOptions options = new CmdOptions().withAdvancedOptions().withGenotypeFile(true).withMapFile(false).withOutputPath(true).withProjectFile(false);
        try {
            CommandLine line = new DefaultParser().parse((Options)options, args);
            CreateProjectSettings projectSettings = options.getCreateProjectSettings(line);
            DataImportSettings importSettings = options.getDataImportSettings(line);
            String filename = options.getOutputPath(line);
            CreateMatrix cMatrix = new CreateMatrix(projectSettings, importSettings, filename);
            cMatrix.doMatrixCreation();
            System.exit(0);
        }
        catch (Exception e) {
            options.printHelp("CreateMatrix");
            System.exit(1);
        }
    }

    public CreateMatrix(CreateProjectSettings projectSettings, DataImportSettings importSettings, String filename) {
        this.projectSettings = projectSettings;
        this.importSettings = importSettings;
        this.filename = filename;
    }

    public void doMatrixCreation() {
        RB.initialize((String)"auto", (String)"res.text.flapjack");
        TaskDialog.setIsHeadless();
        if (this.importSettings.isDecimalEnglish()) {
            Locale.setDefault(Locale.UK);
        }
        CreateProject createProject = new CreateProject(this.projectSettings, this.importSettings);
        try {
            createProject.doProjectCreation();
            this.dataSet = createProject.dataSet();
            this.CreateSimMatrix();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void CreateSimMatrix() throws Exception {
        GTViewSet viewSet = this.dataSet.getViewSets().get(0);
        GTView view = viewSet.getView(0);
        boolean[] chromosomes = new boolean[viewSet.chromosomeCount()];
        for (int i = 0; i < chromosomes.length; ++i) {
            chromosomes[i] = true;
        }
        CalculateSimilarityMatrix calculator = new CalculateSimilarityMatrix(viewSet, view, chromosomes, false);
        calculator.runJob(0);
        SimMatrixExporter exporter = new SimMatrixExporter(calculator.getMatrix(), this.filename);
        exporter.runJob(0);
    }
}

