/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.traits;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.QTL;
import jhi.flapjack.data.QTLInfo;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.traits.QTLPanelNB;
import jhi.flapjack.gui.traits.QTLTableModel;
import scri.commons.gui.Icons;
import scri.commons.gui.RB;
import scri.commons.gui.SystemUtils;
import scri.commons.gui.TaskDialog;

public class QTLPanel
extends JPanel
implements ActionListener {
    private DataSet dataSet;
    private JTable table;
    private QTLTableModel model;
    private QTLPanelNB controls;

    public QTLPanel(DataSet dataSet) {
        this.dataSet = dataSet;
        this.controls = new QTLPanelNB(dataSet);
        this.controls.bImport.addActionListener(this);
        this.controls.bExport.addActionListener(this);
        this.controls.bRemove.addActionListener(this);
        this.controls.bFilter.addActionListener(this);
        this.table = this.controls.table;
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setDefaultRenderer(String.class, new QTLTableModel.NumStrRenderer());
        this.table.setDefaultRenderer(Float.class, new QTLTableModel.NumStrRenderer());
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 0, 0));
        this.add(this.controls);
        this.updateModel();
    }

    public void updateModel() {
        this.model = new QTLTableModel(this.dataSet);
        if ((double)SystemUtils.jreVersion() >= 1.6) {
            new SortHandler();
        }
        this.table.setModel(this.model);
        this.controls.statusLabel.setText(RB.format((String)"gui.traits.QTLPanel.traitCount", (Object[])new Object[]{this.table.getRowCount()}));
        this.controls.errorLabel.setVisible(this.model.qtlOffMap);
        if (this.table.getColumnCount() > 0) {
            this.table.getColumnModel().getColumn(0).setCellRenderer(new QTLNameRenderer());
        }
        this.controls.bExport.setEnabled(this.table.getColumnCount() - 1 > 0);
        this.controls.bFilter.setEnabled(this.table.getColumnCount() - 1 > 0);
        this.controls.bRemove.setEnabled(this.table.getColumnCount() - 1 > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.controls.bImport) {
            Flapjack.winMain.mFile.fileImport(2);
        } else if (e.getSource() == this.controls.bExport) {
            Flapjack.winMain.mData.dataExportQTLs();
        } else if (e.getSource() == this.controls.bRemove) {
            String msg = RB.getString((String)"gui.traits.QTLPanel.removeMsg");
            String[] options = new String[]{RB.getString((String)"gui.traits.TraitsPanel.remove"), RB.getString((String)"gui.text.cancel")};
            int response = TaskDialog.show((String)msg, (int)3, (int)1, (String[])options);
            if (response == 0) {
                this.removeAllTraits();
            }
        } else if (e.getSource() == this.controls.bFilter) {
            Flapjack.winMain.mData.dataFilterQTLs();
        }
    }

    private void removeAllTraits() {
        for (ChromosomeMap c : this.dataSet.getChromosomeMaps()) {
            c.getQtls().clear();
            c.getQtls().trimToSize();
        }
        for (GTViewSet viewSet : this.dataSet.getViewSets()) {
            for (GTView view : viewSet.getViews()) {
                view.setQTLs(new ArrayList<QTLInfo>());
            }
        }
        this.updateModel();
        Actions.projectModified();
    }

    class QTLNameRenderer
    extends DefaultTableCellRenderer {
        QTLNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            QTL qtl = (QTL)table.getValueAt(row, 0);
            this.setText(qtl.getName());
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            if (qtl.isAllowed()) {
                BufferedImage image = new BufferedImage(20, 10, 1);
                Graphics2D g = image.createGraphics();
                Color c = qtl.getDisplayColor();
                Color c1 = c.brighter();
                Color c2 = c.darker();
                g.setPaint(new GradientPaint(0.0f, 0.0f, c1, 20.0f, 10.0f, c2));
                g.fillRect(0, 0, 20, 10);
                g.setColor(Color.black);
                g.drawRect(0, 0, 20, 10);
                g.dispose();
                this.setIcon(new ImageIcon(image));
            } else {
                this.setIcon(Icons.getIcon((String)"QTLDISABLED"));
            }
            return this;
        }
    }

    private class SortHandler {
        SortHandler() {
            QTLPanel.this.table.setRowSorter(new TableRowSorter<QTLTableModel>(QTLPanel.this.model));
        }
    }
}

