/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.StateTable;

public class OptimizeStateTable {
    private DataSet dataSet;
    private StateTable stateTable;

    public OptimizeStateTable(DataSet dataSet) {
        this.dataSet = dataSet;
        this.stateTable = dataSet.getStateTable();
    }

    public void collapseHomzEncodedAsHet() {
        for (int i = 1; i < this.stateTable.size(); ++i) {
            AlleleState s = this.stateTable.getAlleleState(i);
            if (!s.isHomzEncodedAsHet()) continue;
            s = new AlleleState(s.getState(0), "");
            this.stateTable.getStates().set(i, s);
        }
        this.optimize(true);
    }

    public void optimize(boolean compareHomzOnly) {
        int i;
        ArrayList<AlleleState> remapRef = new ArrayList<AlleleState>(this.stateTable.size());
        for (AlleleState as : this.stateTable.getStates()) {
            remapRef.add(as);
        }
        ArrayList<Integer> toDelete = new ArrayList<Integer>();
        for (i = 1; i < this.stateTable.size(); ++i) {
            for (int j = i + 1; j < this.stateTable.size(); ++j) {
                AlleleState s1 = this.stateTable.getAlleleState(i);
                AlleleState alleleState = this.stateTable.getAlleleState(j);
                if (!compareHomzOnly && !s1.matches(alleleState) || compareHomzOnly && !s1.isSameHomzAs(alleleState)) continue;
                remapRef.set(j, s1);
                toDelete.add(j);
            }
        }
        Collections.sort(toDelete);
        for (i = toDelete.size() - 1; i >= 0; --i) {
            this.stateTable.deleteState((Integer)toDelete.get(i));
        }
        ArrayList<Integer> remap = new ArrayList<Integer>();
        for (AlleleState as : remapRef) {
            remap.add(this.stateTable.getStates().indexOf(as));
        }
        if (toDelete.size() > 0) {
            for (int i2 = 0; i2 < this.dataSet.countLines(); ++i2) {
                Line line = this.dataSet.getLineByIndex(i2);
                line.collapseStates(remap);
            }
            Map<String, ArrayList<Integer>> favAlleles = this.dataSet.getFavAlleleManager().getFavAlleles();
            for (ArrayList arrayList : favAlleles.values()) {
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    arrayList.set(i3, remap.get((Integer)arrayList.get(i3)));
                }
            }
            Map<String, ArrayList<Integer>> unfavAlleles = this.dataSet.getFavAlleleManager().getUnfavAlleles();
            for (ArrayList<Integer> allelesForMarker : unfavAlleles.values()) {
                for (int i4 = 0; i4 < allelesForMarker.size(); ++i4) {
                    allelesForMarker.set(i4, remap.get(allelesForMarker.get(i4)));
                }
            }
        }
    }
}

