/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import javax.swing.JMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.NavPanel;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.AlleleFrequencyDialog;
import jhi.flapjack.gui.dialog.ColorDialog;
import jhi.flapjack.gui.dialog.ExportDataDialog;
import jhi.flapjack.gui.dialog.ExportImageDialog;
import jhi.flapjack.gui.dialog.SelectLMDialog;
import jhi.flapjack.gui.visualization.GenotypePanel;

public class MenuVisualization {
    private GenotypePanel gPanel;

    void setComponents(NavPanel navPanel) {
        this.gPanel = navPanel.getGenotypePanel();
    }

    void vizExportImage() {
        ExportImageDialog dialog = new ExportImageDialog(this.gPanel);
    }

    void vizExportData() {
        ExportDataDialog dialog = new ExportDataDialog(this.gPanel.getViewSet());
    }

    void vizColorCustomize() {
        new ColorDialog(Flapjack.winMain, this.gPanel);
    }

    public void vizColor(int colorScheme) {
        if (colorScheme == 2 || colorScheme == 12) {
            SelectLMDialog dialog = new SelectLMDialog(this.gPanel.getView(), true);
            if (!dialog.isOK()) {
                return;
            }
            this.gPanel.getView().mouseOverLine = dialog.getSelectedIndex();
            this.gPanel.getView().initializeComparisons();
        } else if (colorScheme == 4) {
            SelectLMDialog dialog = new SelectLMDialog(this.gPanel.getView(), false);
            if (!dialog.isOK()) {
                return;
            }
            this.gPanel.getView().mouseOverMarker = dialog.getSelectedIndex();
            this.gPanel.getView().initializeComparisons();
        } else if (colorScheme == 7) {
            AlleleFrequencyDialog dialog = new AlleleFrequencyDialog(this.gPanel);
            System.out.println("dialog.isOK()=" + dialog.isOK());
            if (!dialog.isOK()) {
                return;
            }
        } else if (colorScheme == 50 || colorScheme == 51) {
            this.gPanel.getViewSet().setRandomColorSeed((int)(Math.random() * 50000.0));
        }
        this.gPanel.getViewSet().setColorScheme(colorScheme);
        this.gPanel.refreshView();
        Actions.projectModified();
    }

    void vizOverlayGenotypes() {
        Prefs.visShowGenotypes = !Prefs.visShowGenotypes;
        Actions.vizOverlayGenotypes.putValue("SwingSelectedKey", Prefs.visShowGenotypes);
        this.gPanel.refreshView();
    }

    void vizDisableGradients() {
        Prefs.visDisableGradients = !Prefs.visDisableGradients;
        Actions.vizDisableGradients.putValue("SwingSelectedKey", Prefs.visDisableGradients);
        this.gPanel.refreshView();
    }

    void vizHighlightHtZ() {
        Prefs.visHighlightHtZ = !Prefs.visHighlightHtZ;
        Actions.vizHighlightHtZ.putValue("SwingSelectedKey", Prefs.visHighlightHtZ);
        this.gPanel.refreshView();
    }

    void vizHighlightHoZ() {
        Prefs.visHighlightHoZ = !Prefs.visHighlightHoZ;
        Actions.vizHighlightHoZ.putValue("SwingSelectedKey", Prefs.visHighlightHoZ);
        this.gPanel.refreshView();
    }

    void vizHighlightGaps() {
        Prefs.visHighlightGaps = !Prefs.visHighlightGaps;
        Actions.vizHighlightGaps.putValue("SwingSelectedKey", Prefs.visHighlightGaps);
        this.gPanel.refreshView();
    }

    void vizCreatePedigree() {
    }

    void vizScaling(int method) {
        Prefs.visMapScaling = method;
        Actions.vizScalingLocal.putValue("SwingSelectedKey", Prefs.visMapScaling == 0);
        Actions.vizScalingGlobal.putValue("SwingSelectedKey", Prefs.visMapScaling == 1);
        Actions.vizScalingClassic.putValue("SwingSelectedKey", Prefs.visMapScaling == 2);
        this.gPanel.refreshView();
    }

    public void handleColorMenu(JMenu mVizColor) {
        mVizColor.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                int cScheme = 0;
                try {
                    cScheme = MenuVisualization.this.gPanel.getViewSet().getColorScheme();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Actions.vizColorNucleotide.putValue("SwingSelectedKey", cScheme == 1);
                Actions.vizColorNucleotide01.putValue("SwingSelectedKey", cScheme == 10);
                Actions.vizColorABHData.putValue("SwingSelectedKey", cScheme == 8);
                Actions.vizColorLineSim.putValue("SwingSelectedKey", cScheme == 2);
                Actions.vizColorLineSimExact.putValue("SwingSelectedKey", cScheme == 12);
                Actions.vizColorMarkerSim.putValue("SwingSelectedKey", cScheme == 4);
                Actions.vizColorSimple2Color.putValue("SwingSelectedKey", cScheme == 6);
                Actions.vizColorAlleleFreq.putValue("SwingSelectedKey", cScheme == 7);
                Actions.vizColorBinned.putValue("SwingSelectedKey", cScheme == 9);
                Actions.vizColorRandom.putValue("SwingSelectedKey", cScheme == 50);
                Actions.vizColorRandomWSP.putValue("SwingSelectedKey", cScheme == 51);
                Actions.vizColorMagic.putValue("SwingSelectedKey", cScheme == 11);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }
}

