/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui;

import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.InsetsUIResource;
import scri.commons.gui.SystemUtils;

public class UIScaler {
    private static int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
    public static float UI = 1.0f;
    private static UIDefaults origDefaults;

    public static float init(float uiScale, boolean auto) {
        UI = uiScale;
        if (auto) {
            UI = SystemUtils.isMacOS() ? 1.0f : (float)dpi / 96.0f;
        }
        System.out.println("DPI: " + dpi + ", scaling: " + UI + ", auto=" + auto);
        return UI;
    }

    private static void overrideDefaults() {
        if (origDefaults == null) {
            UIScaler.getDefaults();
        }
        UIDefaults uiDefaults = UIManager.getDefaults();
        InsetsUIResource m = (InsetsUIResource)origDefaults.get("Button.margin");
        uiDefaults.put("Button.margin", new InsetsUIResource(UIScaler.scale(m.top), UIScaler.scale(m.left), UIScaler.scale(m.bottom), UIScaler.scale(m.right)));
        uiDefaults.put("TabbedPane.tabInsets", new Insets(UIScaler.scale(1), UIScaler.scale(4), UIScaler.scale(1), UIScaler.scale(4)));
        int treeRowHeight = origDefaults.getInt("Tree.rowHeight");
        uiDefaults.put("Tree.rowHeight", (Object)UIScaler.scale(treeRowHeight));
    }

    private static void getDefaults() {
        origDefaults = new UIDefaults();
        UIDefaults uiDefaults = UIManager.getDefaults();
        for (Map.Entry entry : uiDefaults.entrySet()) {
            origDefaults.put(entry.getKey(), entry.getValue());
        }
    }

    public static Font getFont(Font font) {
        return font.deriveFont(font.getStyle(), Math.round((float)font.getSize() * UI));
    }

    public static int scale(int value) {
        return UI == 1.0f ? value : Math.round((float)value * UI);
    }

    public static void setCellHeight(JComponent c) {
        if (UI == 1.0f) {
            return;
        }
        Font font = UIManager.getFont("Label.font");
        int height = c.getFontMetrics(font).getHeight();
        if (c instanceof JTable) {
            ((JTable)c).setRowHeight(height + UIScaler.scale(2));
        }
    }
}

