/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import jhi.flapjack.data.GTView;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.undo.HidLinesState;
import jhi.flapjack.gui.visualization.undo.HidMarkersState;
import scri.commons.gui.RB;
import scri.commons.gui.SystemUtils;
import scri.commons.gui.TaskDialog;
import scri.commons.gui.matisse.DialogPanel;

public class HideLMDialog
extends JDialog
implements ActionListener {
    private boolean isOK = false;
    private String i18n = "lines";
    private GenotypePanel gPanel;
    private GTView view;
    private JButton bCancel;
    private JButton bHelp;
    private JButton bOK;
    JButton bRestore;
    private JLabel countLabel;
    private DialogPanel dialogPanel1;
    private JLabel hideHint;
    private JLabel hideLabel;
    private JPanel hidePanel;
    private JRadioButton rHideSelected;
    private JRadioButton rHideUnselected;
    private JLabel showLabel;
    private JPanel showPanel;

    public HideLMDialog(GenotypePanel gPanel, boolean markers) {
        super(Flapjack.winMain, "", true);
        this.gPanel = gPanel;
        this.view = gPanel.getView();
        if (markers) {
            this.i18n = "markers";
        }
        this.setTitle(RB.getString((String)("gui.dialog.HideLMDialog." + this.i18n + ".title")));
        this.initComponents();
        this.initComponents2();
        FlapjackUtils.initDialog(this, this.bOK, this.bCancel, true, this.getContentPane(), this.hidePanel, this.showPanel);
    }

    private void initComponents2() {
        int selected;
        int total;
        RB.setText((AbstractButton)this.bOK, (String)"gui.text.ok");
        this.bOK.addActionListener(this);
        RB.setText((AbstractButton)this.bCancel, (String)"gui.text.cancel");
        this.bCancel.addActionListener(this);
        RB.setText((AbstractButton)this.bHelp, (String)"gui.text.help");
        if (this.i18n.equals("lines")) {
            FlapjackUtils.setHelp(this.bHelp, "_-_Show/Hide_Lines");
        } else {
            FlapjackUtils.setHelp(this.bHelp, "_-_Show/Hide_Markers");
        }
        if (this.i18n.equals("markers")) {
            total = this.view.countGenuineMarkers();
            selected = this.view.countSelectedMarkers();
        } else {
            total = this.view.lineCount();
            selected = this.view.countSelectedLines();
        }
        int unselected = total - selected;
        this.rHideSelected.setText(RB.format((String)("gui.dialog.NBHideLMPanel." + this.i18n + ".rHideSelected"), (Object[])new Object[]{selected, total}));
        this.rHideUnselected.setText(RB.format((String)("gui.dialog.NBHideLMPanel." + this.i18n + ".rHideUnselected"), (Object[])new Object[]{unselected, total}));
        RB.setMnemonic((AbstractButton)this.rHideSelected, (String)("gui.dialog.NBHideLMPanel." + this.i18n + ".rHideSelected"));
        RB.setMnemonic((AbstractButton)this.rHideUnselected, (String)("gui.dialog.NBHideLMPanel." + this.i18n + ".rHideUnselected"));
        ButtonGroup bGroup = new ButtonGroup();
        bGroup.add(this.rHideSelected);
        bGroup.add(this.rHideUnselected);
        this.hidePanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)("gui.dialog.NBHideLMPanel." + this.i18n + ".hidePanel.title"))));
        RB.setText((JLabel)this.hideLabel, (String)("gui.dialog.NBHideLMPanel." + this.i18n + ".hideLabel"));
        this.showPanel.setBorder(BorderFactory.createTitledBorder(RB.getString((String)("gui.dialog.NBHideLMPanel." + this.i18n + ".showPanel.title"))));
        RB.setText((JLabel)this.showLabel, (String)("gui.dialog.NBHideLMPanel." + this.i18n + ".showLabel"));
        RB.setText((AbstractButton)this.bRestore, (String)("gui.dialog.NBHideLMPanel." + this.i18n + ".bRestore"));
        if (SystemUtils.isMacOS()) {
            this.hideHint.setText(RB.format((String)("gui.dialog.NBHideLMPanel." + this.i18n + ".hideHintOSX"), (Object[])new Object[]{RB.getString((String)"gui.StatusBar.cmnd")}));
        } else {
            RB.setText((JLabel)this.hideHint, (String)("gui.dialog.NBHideLMPanel." + this.i18n + ".hideHint"));
        }
        if (this.i18n.equals("markers")) {
            this.rHideSelected.setSelected(Prefs.guiHideSelectedMarkers);
            this.rHideUnselected.setSelected(!Prefs.guiHideSelectedMarkers);
            this.countLabel.setText(RB.format((String)"gui.dialog.NBHideLMPanel.countLabel", (Object[])new Object[]{this.view.hiddenMarkerCount()}));
            if (this.view.hiddenMarkerCount() == 0) {
                this.bRestore.setEnabled(false);
            }
        } else {
            this.rHideSelected.setSelected(Prefs.guiHideSelectedLines);
            this.rHideUnselected.setSelected(!Prefs.guiHideSelectedLines);
            this.countLabel.setText(RB.format((String)"gui.dialog.NBHideLMPanel.countLabel", (Object[])new Object[]{this.view.getViewSet().hiddenLineCount()}));
            if (this.view.getViewSet().hiddenLineCount() == 0L) {
                this.bRestore.setEnabled(false);
            }
        }
        this.bRestore.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bRestore && !this.restore()) {
            return;
        }
        if (e.getSource() == this.bOK) {
            if (this.i18n.equals("markers")) {
                Prefs.guiHideSelectedMarkers = this.rHideSelected.isSelected();
            } else {
                Prefs.guiHideSelectedLines = this.rHideSelected.isSelected();
            }
            this.isOK = true;
        }
        this.setVisible(false);
    }

    public boolean isOK() {
        return this.isOK;
    }

    private boolean restore() {
        if (this.i18n.equals("lines")) {
            return this.restoreHiddenLines();
        }
        return this.restoreHiddenMarkers();
    }

    private boolean restoreHiddenLines() {
        String msg = RB.getString((String)"gui.dialog.HideLMDialog.lines.restoreMsg");
        String[] options = new String[]{RB.getString((String)"gui.dialog.HideLMDialog.restore"), RB.getString((String)"gui.text.cancel")};
        if (TaskDialog.show((String)msg, (int)3, (int)1, (String[])options) != 0) {
            return false;
        }
        HidLinesState state = new HidLinesState(this.gPanel.getViewSet(), RB.getString((String)"gui.visualization.HidLinesState.restoredLines"));
        state.createUndoState();
        this.gPanel.getViewSet().restoreHiddenLines();
        this.gPanel.refreshView();
        state.createRedoState();
        this.gPanel.addUndoState(state);
        return true;
    }

    private boolean restoreHiddenMarkers() {
        String msg = RB.getString((String)"gui.dialog.HideLMDialog.markers.restoreMsg");
        String[] options = new String[]{RB.getString((String)"gui.dialog.HideLMDialog.restore"), RB.getString((String)"gui.text.cancel")};
        if (TaskDialog.show((String)msg, (int)3, (int)1, (String[])options) != 0) {
            return false;
        }
        HidMarkersState state = new HidMarkersState(this.gPanel.getView(), RB.getString((String)"gui.visualization.HidMarkersState.restoredMarkers"));
        state.createUndoState();
        this.gPanel.getView().restoreHiddenMarkers();
        this.gPanel.refreshView();
        state.createRedoState();
        this.gPanel.addUndoState(state);
        return true;
    }

    private void initComponents() {
        this.hidePanel = new JPanel();
        this.rHideUnselected = new JRadioButton();
        this.rHideSelected = new JRadioButton();
        this.hideLabel = new JLabel();
        this.hideHint = new JLabel();
        this.showPanel = new JPanel();
        this.showLabel = new JLabel();
        this.bRestore = new JButton();
        this.countLabel = new JLabel();
        this.dialogPanel1 = new DialogPanel();
        this.bOK = new JButton();
        this.bCancel = new JButton();
        this.bHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.hidePanel.setBorder(BorderFactory.createTitledBorder("Hide markers:"));
        this.rHideUnselected.setText("Hide all the markers that are NOT currently selected");
        this.rHideSelected.setText("Hide all the markers that ARE currently selected");
        this.hideLabel.setText("hideLabel");
        this.hideHint.setText("hideHint");
        GroupLayout hidePanelLayout = new GroupLayout(this.hidePanel);
        this.hidePanel.setLayout(hidePanelLayout);
        hidePanelLayout.setHorizontalGroup(hidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hidePanelLayout.createSequentialGroup().addContainerGap().addGroup(hidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rHideSelected).addComponent(this.rHideUnselected).addComponent(this.hideLabel).addComponent(this.hideHint)).addContainerGap(-1, Short.MAX_VALUE)));
        hidePanelLayout.setVerticalGroup(hidePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(hidePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.hideLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rHideUnselected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rHideSelected).addGap(18, 18, 18).addComponent(this.hideHint).addContainerGap(-1, Short.MAX_VALUE)));
        this.showPanel.setBorder(BorderFactory.createTitledBorder("Show markers:"));
        this.showLabel.setText("Click to restore all currently hidden markers to the view:");
        this.bRestore.setText("Show hidden markers");
        this.countLabel.setText("(0 currently hidden)");
        GroupLayout showPanelLayout = new GroupLayout(this.showPanel);
        this.showPanel.setLayout(showPanelLayout);
        showPanelLayout.setHorizontalGroup(showPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(showPanelLayout.createSequentialGroup().addContainerGap().addGroup(showPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showLabel).addGroup(showPanelLayout.createSequentialGroup().addComponent(this.bRestore).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.countLabel))).addContainerGap(13, Short.MAX_VALUE)));
        showPanelLayout.setVerticalGroup(showPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(showPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.showLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(showPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bRestore).addComponent(this.countLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.bOK.setText("OK");
        this.dialogPanel1.add((Component)this.bOK);
        this.bCancel.setText("Cancel");
        this.dialogPanel1.add((Component)this.bCancel);
        this.bHelp.setText("Help");
        this.dialogPanel1.add((Component)this.bHelp);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.showPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.hidePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()).addComponent((Component)this.dialogPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.hidePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent((Component)this.dialogPanel1, -2, 44, -2)));
        this.pack();
    }
}

