/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.data.QTLInfo;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.dialog.AlleleFrequencyDialog;
import jhi.flapjack.gui.visualization.CanvasMouseListener;
import jhi.flapjack.gui.visualization.CrosshairOverlay;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.IOverlayRenderer;
import jhi.flapjack.gui.visualization.SplitterOverlay;
import jhi.flapjack.gui.visualization.colors.ABHDataColorScheme;
import jhi.flapjack.gui.visualization.colors.AlleleFrequencyColorScheme;
import jhi.flapjack.gui.visualization.colors.BinnedColorScheme;
import jhi.flapjack.gui.visualization.colors.ColorScheme;
import jhi.flapjack.gui.visualization.colors.LineSimilarityColorScheme;
import jhi.flapjack.gui.visualization.colors.LineSimilarityExactColorScheme;
import jhi.flapjack.gui.visualization.colors.MagicColorScheme;
import jhi.flapjack.gui.visualization.colors.MarkerSimilarityColorScheme;
import jhi.flapjack.gui.visualization.colors.Nucleotide01ColorScheme;
import jhi.flapjack.gui.visualization.colors.NucleotideColorScheme;
import jhi.flapjack.gui.visualization.colors.RandomColorScheme;
import jhi.flapjack.gui.visualization.colors.SimpleTwoColorScheme;

class GenotypeCanvas
extends JPanel {
    private GenotypePanel gPanel;
    GTViewSet viewSet;
    GTView view;
    ColorScheme cScheme;
    boolean locked = false;
    CrosshairOverlay crosshair;
    int boxTotalX;
    int boxTotalY;
    int canvasW;
    int canvasH;
    int boxW;
    int boxH;
    int boxCountX;
    int boxCountY;
    int pX1;
    int pY1;
    int pX2;
    int pY2;
    int pX2Max;
    int pY2Max;
    private int xS;
    private int xE;
    private int yE;
    float gtCenterX;
    float gtCenterY;
    private Dimension dimension = new Dimension();
    BufferedImage imageViewPort;
    private boolean redraw = true;
    LinkedList<IOverlayRenderer> overlays = new LinkedList();
    HashSet<Integer> qtlHash = new HashSet();
    private int cores = Runtime.getRuntime().availableProcessors();
    private ExecutorService executor;
    private Future[] tasks;

    GenotypeCanvas(GenotypePanel gPanel, WinMain winMain) {
        this.gPanel = gPanel;
        this.setOpaque(false);
        this.setBackground(Prefs.visColorBackground);
        new CanvasMouseListener(gPanel, this, winMain);
        AbstractAction pageLeft = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.viewPageLeft.actionPerformed(e);
            }
        };
        AbstractAction pageRight = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.viewPageRight.actionPerformed(e);
            }
        };
        this.getInputMap(2).put(KeyStroke.getKeyStroke(91, 0), "left");
        this.getActionMap().put("left", pageLeft);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(93, 0), "right");
        this.getActionMap().put("right", pageRight);
        this.executor = Executors.newFixedThreadPool(this.cores);
        this.tasks = new Future[this.cores];
        this.overlays.add(new SplitterOverlay(gPanel));
        this.crosshair = new CrosshairOverlay(gPanel);
        this.overlays.add(this.crosshair);
    }

    void setView(GTViewSet viewSet, GTView view) {
        this.viewSet = viewSet;
        this.view = view;
        this.qtlHash = new HashSet();
        for (MarkerInfo info : view.getMarkers()) {
            for (QTLInfo qtlInfo : view.getQTLs()) {
                if (!qtlInfo.getQTL().isVisible() || !(info.position() >= qtlInfo.min()) || !(info.position() <= qtlInfo.max())) continue;
                this.qtlHash.add(info.getIndex());
            }
        }
    }

    void setDimensions(int sizeX, int sizeY) {
        Font font = new Font("Monospaced", 0, sizeY);
        FontMetrics fm = new BufferedImage(1, 1, 1).getGraphics().getFontMetrics(font);
        this.boxW = Prefs.visLinkSliders ? sizeY * 2 : sizeX * 2;
        this.boxH = fm.getHeight();
        this.boxTotalX = this.view.markerCount();
        this.boxTotalY = this.view.lineCount();
        this.canvasW = this.boxTotalX * this.boxW;
        this.canvasH = this.boxTotalY * this.boxH;
        this.dimension = new Dimension(this.canvasW, this.canvasH);
        this.setSize(this.dimension);
        this.updateColorScheme();
        this.resetBufferedState(true);
    }

    void updateColorScheme() {
        switch (this.viewSet.getColorScheme()) {
            case 1: {
                this.cScheme = new NucleotideColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 10: {
                this.cScheme = new Nucleotide01ColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 8: {
                this.cScheme = new ABHDataColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 2: {
                this.cScheme = new LineSimilarityColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 12: {
                this.cScheme = new LineSimilarityExactColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 4: {
                this.cScheme = new MarkerSimilarityColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 6: {
                this.cScheme = new SimpleTwoColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 7: {
                if (AlleleFrequencyDialog.calculate(this.viewSet)) {
                    this.cScheme = new AlleleFrequencyColorScheme(this.view, this.boxW, this.boxH);
                    break;
                }
                this.gPanel.getViewSet().setColorScheme(1);
                this.cScheme = new NucleotideColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 9: {
                this.cScheme = new BinnedColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            case 50: {
                this.cScheme = new RandomColorScheme(50, this.view, this.boxW, this.boxH);
                break;
            }
            case 51: {
                this.cScheme = new RandomColorScheme(51, this.view, this.boxW, this.boxH);
                break;
            }
            case 11: {
                this.cScheme = new MagicColorScheme(this.view, this.boxW, this.boxH);
                break;
            }
            default: {
                this.cScheme = new NucleotideColorScheme(this.view, this.boxW, this.boxH);
            }
        }
        this.redraw = true;
    }

    void computeForRedraw(Dimension viewSize, Point viewPosition) {
        this.boxCountX = 1 + (int)((float)viewSize.getWidth() / (float)this.boxW);
        this.boxCountY = 1 + (int)((float)viewSize.getHeight() / (float)this.boxH);
        this.pX1 = viewPosition.x;
        this.pX2 = this.pX2Max = this.pX1 + viewSize.width - 1;
        this.pY1 = viewPosition.y;
        this.pY2 = this.pY2Max = this.pY1 + viewSize.height - 1;
        if (this.pX2 >= this.canvasW) {
            this.pX2 = this.canvasW - 1;
        }
        if (this.pY2 >= this.canvasH) {
            this.pY2 = this.canvasH - 1;
        }
        this.gtCenterX = this.pX1 / this.boxW + viewSize.width / this.boxW / 2;
        this.gtCenterY = this.pY1 / this.boxH + viewSize.height / this.boxH / 2;
        this.updateOverviewSelectionBox();
        this.redraw = true;
        this.repaint();
    }

    void updateOverviewSelectionBox() {
        this.gPanel.canvasViewChanged(this.pX1 / this.boxW, this.boxCountX, this.pY1 / this.boxH, this.boxCountY);
    }

    void setHighlightedIndices(int rowIndex, int colIndex) {
        if (rowIndex != this.view.mouseOverLine || colIndex != this.view.mouseOverMarker) {
            this.view.mouseOverLine = rowIndex;
            this.view.mouseOverMarker = colIndex;
        }
        if (Prefs.visCrosshair || Prefs.visTooltip) {
            this.repaint();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.dimension;
    }

    int getMarker(Point mousePoint) {
        return mousePoint.x / this.boxW;
    }

    int getLine(Point mousePoint) {
        return mousePoint.y / this.boxH;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(Prefs.visColorBackground);
        g.fillRect(0, 0, this.canvasW, this.canvasH);
        this.renderViewport(g);
        try {
            for (IOverlayRenderer renderer : this.overlays) {
                renderer.render(g);
            }
        }
        catch (ConcurrentModificationException e) {
            this.repaint();
        }
    }

    private void renderViewport(Graphics2D g) {
        if (this.redraw) {
            int w = this.pX2 - this.pX1 + 1;
            int h = this.pY2 - this.pY1 + 1;
            if (w == 0 || h == 0) {
                h = 1;
                w = 1;
            }
            if (this.imageViewPort == null || this.imageViewPort.getWidth() != w || this.imageViewPort.getHeight() != h) {
                this.imageViewPort = (BufferedImage)this.createImage(w, h);
            }
            Graphics2D gImage = this.imageViewPort.createGraphics();
            gImage.translate(-this.pX1, -this.pY1);
            this.renderRegion(gImage);
            gImage.dispose();
        }
        g.drawImage((Image)this.imageViewPort, this.pX1, this.pY1, null);
        this.redraw = false;
    }

    private void renderRegion(Graphics2D g) {
        this.xS = this.pX1 / this.boxW;
        int yS = this.pY1 / this.boxH;
        this.xE = this.xS + this.boxCountX;
        if (this.xE >= this.boxTotalX) {
            this.xE = this.boxTotalX - 1;
        }
        this.yE = yS + this.boxCountY;
        if (this.yE >= this.boxTotalY) {
            this.yE = this.boxTotalY - 1;
        }
        this.render(g, yS);
    }

    private void renderAll(Graphics2D g) {
        this.xS = 0;
        this.xE = this.boxTotalX - 1;
        int yS = 0;
        this.yE = this.boxTotalY - 1;
        this.render(g, yS);
    }

    private void render(Graphics2D g, int yS) {
        try {
            for (int i = 0; i < this.tasks.length; ++i) {
                this.tasks[i] = this.executor.submit(new LinePainter(g, yS + i));
            }
            for (Future task : this.tasks) {
                task.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void resetBufferedState(boolean createNewBuffer) {
        this.redraw = true;
        this.repaint();
    }

    BufferedImage createSavableImage(boolean full) throws Error, Exception {
        if (!full) {
            return this.imageViewPort;
        }
        BufferedImage image = (BufferedImage)this.createImage(this.canvasW, this.canvasH);
        Graphics2D g = image.createGraphics();
        this.renderAll(g);
        g.dispose();
        return image;
    }

    private final class LinePainter
    implements Runnable {
        private Graphics g;
        private int yS;

        LinePainter(Graphics g, int yS) {
            this.g = g;
            this.yS = yS;
        }

        @Override
        public void run() {
            boolean navMode = Prefs.guiMouseMode == 0;
            boolean markerMode = Prefs.guiMouseMode == 1;
            boolean lineMode = Prefs.guiMouseMode == 2;
            int row = this.yS;
            int y = GenotypeCanvas.this.boxH * this.yS;
            while (row <= GenotypeCanvas.this.yE) {
                int xIndex = GenotypeCanvas.this.xS;
                int x = GenotypeCanvas.this.boxW * GenotypeCanvas.this.xS;
                while (xIndex <= GenotypeCanvas.this.xE) {
                    boolean underQTL = GenotypeCanvas.this.qtlHash.contains(xIndex);
                    if (navMode || markerMode && GenotypeCanvas.this.view.isMarkerSelected(xIndex) || lineMode && GenotypeCanvas.this.view.isLineSelected(row)) {
                        this.g.drawImage(GenotypeCanvas.this.cScheme.getSelectedImage(row, xIndex, underQTL), x, y, null);
                    } else {
                        this.g.drawImage(GenotypeCanvas.this.cScheme.getUnselectedImage(row, xIndex, underQTL), x, y, null);
                    }
                    ++xIndex;
                    x += GenotypeCanvas.this.boxW;
                }
                row += GenotypeCanvas.this.cores;
                y += GenotypeCanvas.this.boxH * GenotypeCanvas.this.cores;
            }
        }
    }
}

