/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.data.results.PedVerLinesResult;
import scri.commons.gui.SimpleJob;

public class PedVerLinesAnalysis
extends SimpleJob {
    private GTViewSet viewSet;
    private AnalysisSet as;
    private StateTable stateTable;
    private int refIndex;
    private int testIndex;
    private String name;

    public PedVerLinesAnalysis(GTViewSet viewSet, boolean[] selectedChromosomes, int refIndex, int testIndex, String name) {
        this(viewSet, selectedChromosomes, refIndex, testIndex);
        this.name = name;
    }

    public PedVerLinesAnalysis(GTViewSet viewSet, boolean[] selectedChromosomes, int refIndex, int testIndex) {
        this.viewSet = viewSet;
        this.stateTable = viewSet.getDataSet().getStateTable();
        this.refIndex = refIndex;
        this.testIndex = testIndex;
        this.moveRefAndTestToTop();
        this.as = new AnalysisSet(viewSet).withViews(selectedChromosomes).withSelectedLines().withSelectedMarkers();
    }

    public void runJob(int index) throws Exception {
        int totalMarkerCount = this.calculateTotalMarkerCount();
        for (int lineIndex = 0; lineIndex < this.as.lineCount(); ++lineIndex) {
            LineInfo lineInfo = this.as.getLine(lineIndex);
            PedVerLinesResult lineStat = new PedVerLinesResult();
            lineInfo.getResults().setPedVerLinesResult(lineStat);
            lineInfo.getResults().setName(this.name);
            int foundMarkers = this.usableMarkerCount(lineIndex);
            double missingPerc = (1.0 - (double)foundMarkers / (double)totalMarkerCount) * 100.0;
            int hetMarkers = this.hetMarkerCount(lineIndex);
            double hetPerc = (double)hetMarkers / (double)foundMarkers * 100.0;
            int totalMatches = this.matchesTestLine(lineIndex);
            ArrayList<Integer> chrMatch = new ArrayList<Integer>();
            for (int c = 0; c < this.as.viewCount(); ++c) {
                chrMatch.add(this.matchesAlleleCountForView(c, lineIndex));
            }
            lineStat.setMarkerCount(foundMarkers);
            lineStat.setMissingPerc(missingPerc);
            lineStat.setHetCount(hetMarkers);
            lineStat.setHetPerc(hetPerc);
            lineStat.setMatchCount(totalMatches);
            lineStat.setMatchPerc((float)totalMatches / (float)foundMarkers * 100.0f);
            lineStat.setChrMatchCount(chrMatch);
        }
    }

    private void moveRefAndTestToTop() {
        LineInfo refLine = this.viewSet.getLines().get(this.refIndex);
        LineInfo testLine = this.viewSet.getLines().get(this.testIndex);
        refLine.getResults().setSortToTop(true);
        testLine.getResults().setSortToTop(true);
        this.viewSet.getLines().remove(refLine);
        this.viewSet.getLines().remove(testLine);
        this.viewSet.getLines().add(0, refLine);
        this.viewSet.getLines().add(1, testLine);
        this.refIndex = 0;
        this.testIndex = 1;
        this.viewSet.setColorScheme(12);
        this.viewSet.setComparisonLineIndex(this.testIndex);
        this.viewSet.setComparisonLine(testLine.getLine());
    }

    private boolean isUsableMarker(int chr, int lineIndex, int marker) {
        return this.as.getState(chr, this.testIndex, marker) != 0 && this.as.getState(chr, lineIndex, marker) != 0;
    }

    private int calculateTotalMarkerCount() {
        int totalMarkerCount = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, this.testIndex, m)) continue;
                ++totalMarkerCount;
            }
        }
        return totalMarkerCount;
    }

    private int usableMarkerCount(int lineIndex) {
        int foundMarkers = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, lineIndex, m)) continue;
                ++foundMarkers;
            }
        }
        return foundMarkers;
    }

    private int hetMarkerCount(int lineIndex) {
        int hetMarkers = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, lineIndex, m) || !this.stateTable.isHet(this.as.getState(c, lineIndex, m))) continue;
                ++hetMarkers;
            }
        }
        return hetMarkers;
    }

    private int matchesTestLine(int lineIndex) {
        int matchesExpF1 = 0;
        for (int c = 0; c < this.as.viewCount(); ++c) {
            for (int m = 0; m < this.as.markerCount(c); ++m) {
                if (!this.isUsableMarker(c, lineIndex, m)) continue;
                AlleleState testState = this.stateTable.getAlleleState(this.as.getState(c, this.testIndex, m));
                AlleleState currState = this.stateTable.getAlleleState(this.as.getState(c, lineIndex, m));
                if (!currState.matchesAnyAllele(testState)) continue;
                ++matchesExpF1;
            }
        }
        return matchesExpF1;
    }

    public int matchesAlleleCountForView(int view, int lineIndex) {
        int matchesCount = 0;
        for (int m = 0; m < this.as.markerCount(view); ++m) {
            if (!this.isUsableMarker(view, lineIndex, m)) continue;
            AlleleState testState = this.stateTable.getAlleleState(this.as.getState(view, this.testIndex, m));
            AlleleState currState = this.stateTable.getAlleleState(this.as.getState(view, lineIndex, m));
            if (!currState.matchesAnyAllele(testState)) continue;
            ++matchesCount;
        }
        return matchesCount;
    }
}

