/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

import ch.systemsx.cisd.base.exceptions.IErrorStrategy;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.unix.FileLinkType;
import ch.systemsx.cisd.base.unix.Unix;
import ch.systemsx.cisd.hdf5.CompoundElement;
import ch.systemsx.cisd.hdf5.CompoundType;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.h5ar.ArchiveEntryCompleteness;
import ch.systemsx.cisd.hdf5.h5ar.ArchivingException;
import ch.systemsx.cisd.hdf5.h5ar.NewArchiveEntry;
import ch.systemsx.cisd.hdf5.h5ar.Utils;
import java.io.File;

@CompoundType(name="Link", mapAllFields=false)
final class LinkRecord
implements Comparable<LinkRecord> {
    @CompoundElement(memberName="linkNameLength")
    private int linkNameLength;
    @CompoundElement(memberName="linkType", typeName="linkType")
    private FileLinkType linkType;
    @CompoundElement(memberName="size")
    private long size;
    @CompoundElement(memberName="lastModified")
    private long lastModified;
    @CompoundElement(memberName="uid")
    private int uid;
    @CompoundElement(memberName="gid")
    private int gid;
    @CompoundElement(memberName="permissions")
    private short permissions;
    @CompoundElement(memberName="checksum")
    private int crc32;
    private boolean hasCrc32Checksum = false;
    private String linkName;
    private String linkTargetOrNull;
    private FileLinkType verifiedType;
    private long verifiedSize = -1L;
    private int verifiedCrc32 = 0;
    private long verifiedLastModified = -1L;

    public static LinkRecord tryCreate(File file, IErrorStrategy errorStrategy) {
        try {
            return new LinkRecord(file);
        }
        catch (IOExceptionUnchecked ex) {
            errorStrategy.dealWithError(new ArchivingException(file, ex.getCause()));
            return null;
        }
    }

    public static String tryReadLinkTarget(File symbolicLink) {
        if (Unix.isOperational()) {
            return Unix.tryReadSymbolicLink(symbolicLink.getPath());
        }
        return null;
    }

    public static LinkRecord tryReadFromArchive(IHDF5Reader hdf5Reader, String normalizedPath) {
        HDF5LinkInformation linfo = hdf5Reader.object().getLinkInformation(normalizedPath);
        if (!linfo.exists()) {
            return null;
        }
        long size = linfo.isDataSet() ? hdf5Reader.object().getSize(linfo.getPath()) : -1L;
        return new LinkRecord(linfo, size);
    }

    LinkRecord() {
    }

    LinkRecord(NewArchiveEntry entry) {
        this(entry.getName(), entry.getLinkTarget(), entry.getLinkType(), -1L, entry.getLastModified(), entry.getUid(), entry.getGid(), entry.getPermissions(), -1);
    }

    LinkRecord(String hdf5DirectoryPath) {
        this(hdf5DirectoryPath, System.currentTimeMillis() / 1000L, Utils.getCurrentUid(), Utils.getCurrentGid(), 493);
    }

    static LinkRecord getLinkRecordForArchiveRoot(File hdf5Archive) {
        if (Unix.isOperational()) {
            Unix.Stat stat = Unix.getFileInfo(hdf5Archive.getPath());
            return new LinkRecord("", stat.getLastModified(), stat.getUid(), stat.getGid(), stat.getPermissions());
        }
        return new LinkRecord("", hdf5Archive.lastModified() / 1000L, Utils.getCurrentUid(), Utils.getCurrentGid(), -1);
    }

    static LinkRecord getLinkRecordForLink(File file) {
        if (Unix.isOperational()) {
            Unix.Stat stat = Unix.getLinkInfo(file.getPath());
            return new LinkRecord(file.getName(), stat.tryGetSymbolicLink(), stat.getLinkType(), stat.getSize(), stat.getLastModified(), stat.getUid(), stat.getGid(), stat.getPermissions(), 0);
        }
        return new LinkRecord(file.getName(), null, file.isDirectory() ? FileLinkType.DIRECTORY : FileLinkType.REGULAR_FILE, file.length(), file.lastModified() / 1000L, Utils.getCurrentUid(), Utils.getCurrentGid(), -1, 0);
    }

    LinkRecord(String hdf5DirectoryPath, long lastModified, int uid, int gid, short permissions) {
        this.linkName = hdf5DirectoryPath;
        this.linkTargetOrNull = null;
        this.linkType = FileLinkType.DIRECTORY;
        this.lastModified = lastModified;
        this.uid = uid;
        this.gid = gid;
        this.permissions = permissions;
    }

    LinkRecord(HDF5LinkInformation info, long size) {
        this.linkName = info.getName();
        this.linkTargetOrNull = info.tryGetSymbolicLinkTarget();
        this.linkType = Utils.translateType(info.getType());
        this.size = size;
        this.lastModified = -1L;
        this.uid = -1;
        this.gid = -1;
        this.permissions = (short)-1;
    }

    private LinkRecord(File file) {
        this.linkName = file.getName();
        if (Unix.isOperational()) {
            Unix.Stat info = Unix.getLinkInfo(file.getPath(), false);
            this.linkType = info.getLinkType();
            this.size = this.linkType == FileLinkType.REGULAR_FILE ? info.getSize() : 0L;
            this.lastModified = info.getLastModified();
            this.uid = info.getUid();
            this.gid = info.getGid();
            this.permissions = info.getPermissions();
        } else {
            this.linkType = file.isDirectory() ? FileLinkType.DIRECTORY : (file.isFile() ? FileLinkType.REGULAR_FILE : FileLinkType.OTHER);
            this.size = this.linkType == FileLinkType.REGULAR_FILE ? file.length() : 0L;
            this.lastModified = file.lastModified() / 1000L;
            this.uid = -1;
            this.gid = -1;
            this.permissions = (short)-1;
        }
        if (this.linkType == FileLinkType.SYMLINK) {
            this.linkTargetOrNull = LinkRecord.tryReadLinkTarget(file);
        }
    }

    LinkRecord(String linkName, String linkTargetOrNull, FileLinkType linkType, long size, long lastModified, int uid, int gid, short permissions, int crc32) {
        this.linkName = linkName;
        this.linkTargetOrNull = linkTargetOrNull;
        this.linkType = linkType;
        this.size = size;
        this.lastModified = lastModified;
        this.uid = uid;
        this.gid = gid;
        this.permissions = permissions;
        this.crc32 = crc32;
    }

    int initAfterReading(String concatenatedNames, int startPos, IHDF5Reader reader, String groupPath, boolean readLinkTarget) {
        this.hasCrc32Checksum = true;
        int endPos = startPos + this.linkNameLength;
        this.linkName = concatenatedNames.substring(startPos, endPos);
        if (readLinkTarget && this.linkType == FileLinkType.SYMLINK) {
            this.linkTargetOrNull = reader.object().getLinkInformation(String.valueOf(groupPath) + "/" + this.linkName).tryGetSymbolicLinkTarget();
        }
        return endPos;
    }

    void addLinkTarget(IHDF5Reader reader, String groupPath) {
        if (this.linkType == FileLinkType.SYMLINK && this.linkTargetOrNull == null) {
            this.linkTargetOrNull = reader.object().getLinkInformation(String.valueOf(groupPath) + "/" + this.linkName).tryGetSymbolicLinkTarget();
        }
    }

    void prepareForWriting(StringBuilder concatenatedNames) {
        this.linkNameLength = this.linkName.length();
        concatenatedNames.append(this.linkName);
    }

    public String getLinkName() {
        return this.linkName;
    }

    public String tryGetLinkTarget() {
        return this.linkTargetOrNull;
    }

    public boolean isDirectory() {
        return this.linkType == FileLinkType.DIRECTORY;
    }

    public boolean isSymLink() {
        return this.linkType == FileLinkType.SYMLINK;
    }

    public boolean isRegularFile() {
        return this.linkType == FileLinkType.REGULAR_FILE;
    }

    public FileLinkType getLinkType() {
        return this.linkType;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getSize() {
        return this.size;
    }

    public boolean hasLastModified() {
        return this.lastModified >= 0L;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean hasUnixPermissions() {
        return this.uid >= 0 && this.gid >= 0 && this.permissions >= 0;
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public short getPermissions() {
        return this.permissions;
    }

    public ArchiveEntryCompleteness getCompleteness() {
        if (this.hasUnixPermissions()) {
            return ArchiveEntryCompleteness.FULL;
        }
        if (this.hasLastModified()) {
            return ArchiveEntryCompleteness.LAST_MODIFIED;
        }
        return ArchiveEntryCompleteness.BASE;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public void setCrc32(int crc32) {
        this.crc32 = crc32;
        this.hasCrc32Checksum = true;
    }

    boolean hasCRC32Checksum() {
        return this.hasCrc32Checksum;
    }

    public FileLinkType getVerifiedType() {
        return this.verifiedType;
    }

    public void setVerifiedType(FileLinkType verifiedType) {
        this.verifiedType = verifiedType;
    }

    public int getVerifiedCrc32() {
        return this.verifiedCrc32;
    }

    public long getVerifiedSize() {
        return this.verifiedSize;
    }

    public long getVerifiedLastModified() {
        return this.verifiedLastModified;
    }

    public void setFileVerification(long size, int crc32, long lastModified) {
        this.verifiedSize = size;
        this.verifiedCrc32 = crc32;
        this.verifiedLastModified = lastModified;
    }

    public void resetVerification() {
        this.verifiedType = null;
        this.verifiedSize = -1L;
        this.verifiedCrc32 = 0;
        this.verifiedLastModified = -1L;
    }

    @Override
    public int compareTo(LinkRecord o) {
        if (this.isDirectory() && !o.isDirectory()) {
            return -1;
        }
        if (!this.isDirectory() && o.isDirectory()) {
            return 1;
        }
        return this.getLinkName().compareTo(o.getLinkName());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof LinkRecord)) {
            return false;
        }
        LinkRecord that = (LinkRecord)obj;
        return this.linkName.equals(that.linkName);
    }

    public int hashCode() {
        return this.linkName.hashCode();
    }

    public String toString() {
        return "LinkRecord [linkName=" + this.linkName + ", linkType=" + this.linkType + ", size=" + this.size + ", lastModified=" + this.lastModified + ", uid=" + this.uid + ", gid=" + this.gid + ", permissions=" + this.permissions + ", crc32=" + this.crc32 + ", linkTargetOrNull=" + this.linkTargetOrNull + "]";
    }
}

