/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class Hdf5ToFJTabbedConverter {
    private static final String LINES = "Lines";
    private static final String MARKERS = "Markers";
    private static final String DATA = "DataMatrix";
    private static final String STATE_TABLE = "StateTable";
    private File hdf5File;
    private LinkedHashSet<String> lines = null;
    private LinkedHashSet<String> markers = null;
    private boolean missingDataFilter = false;
    private boolean heterozygousFilter = false;
    private HashMap<String, Integer> lineInds;
    private HashMap<String, Integer> markerInds;
    private IHDF5Reader reader;
    private LinkedHashSet<String> hdf5Lines;
    private LinkedHashSet<String> hdf5Markers;

    public Hdf5ToFJTabbedConverter(File hdf5File, List<String> lines, List<String> markers, boolean missingDataFilter, boolean heterozygousFilter) {
        this.hdf5File = hdf5File;
        this.lines = new LinkedHashSet<String>(lines);
        this.markers = new LinkedHashSet<String>(markers);
        this.missingDataFilter = missingDataFilter;
        this.heterozygousFilter = heterozygousFilter;
    }

    public static void main(String[] args) {
        File hdf5File = null;
        String outputFilePath = null;
        List<String> lines = null;
        List<String> markers = null;
        boolean missingDataFilter = false;
        boolean heterozygousFilter = false;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-hdf5=")) {
                    hdf5File = new File(args[i].substring(6));
                }
                if (args[i].startsWith("-genotypes=")) {
                    outputFilePath = args[i].substring(11);
                }
                if (args[i].startsWith("-lines=")) {
                    lines = Files.readAllLines(new File(args[i].substring(7)).toPath());
                }
                if (args[i].startsWith("-markers=")) {
                    markers = Files.readAllLines(new File(args[i].substring(9)).toPath());
                }
                if (args[i].startsWith("-missingFilter=")) {
                    missingDataFilter = Boolean.valueOf(args[i].substring(15));
                }
                if (!args[i].startsWith("-heterozygousFilter=")) continue;
                heterozygousFilter = Boolean.valueOf(args[i].substring(21));
            }
            if (hdf5File == null || outputFilePath == null || lines == null || markers == null) {
                Hdf5ToFJTabbedConverter.printHelp();
                System.exit(1);
            }
            Hdf5ToFJTabbedConverter extractor = new Hdf5ToFJTabbedConverter(hdf5File, lines, markers, missingDataFilter, heterozygousFilter);
            extractor.readInput();
            extractor.extractData(outputFilePath, "");
        }
        catch (IOException e) {
            Hdf5ToFJTabbedConverter.printHelp();
            e.printStackTrace();
        }
    }

    public void readInput() {
        this.reader = HDF5Factory.openForReading((File)this.hdf5File);
        long s = System.currentTimeMillis();
        System.out.println();
        System.out.println("Hdf5 file opened for reading: " + (System.currentTimeMillis() - s) + " (ms)");
        s = System.currentTimeMillis();
        String[] hdf5LinesArray = this.reader.readStringArray(LINES);
        this.hdf5Lines = new LinkedHashSet<String>(Arrays.asList(hdf5LinesArray));
        this.lines = this.lines == null ? this.hdf5Lines : this.lines.stream().filter(line -> this.hdf5Lines.contains(line)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.lineInds = new HashMap();
        for (int i = 0; i < hdf5LinesArray.length; ++i) {
            this.lineInds.put(hdf5LinesArray[i], i);
        }
        System.out.println();
        System.out.println("Read and filtered lines: " + (System.currentTimeMillis() - s) + " (ms)");
        s = System.currentTimeMillis();
        String[] hdf5MarkersArray = this.reader.readStringArray(MARKERS);
        this.hdf5Markers = new LinkedHashSet<String>(Arrays.asList(hdf5MarkersArray));
        this.markers = this.markers == null ? this.hdf5Markers : this.markers.stream().filter(marker -> this.hdf5Markers.contains(marker)).collect(Collectors.toCollection(LinkedHashSet::new));
        this.markerInds = new HashMap();
        for (int i = 0; i < hdf5MarkersArray.length; ++i) {
            this.markerInds.put(hdf5MarkersArray[i], i);
        }
        System.out.println();
        System.out.println("Read and filtered markers: " + (System.currentTimeMillis() - s) + " (ms)");
        this.reader.close();
    }

    public void extractData(String outputFile, String headerLines) {
        System.out.println();
        long s = System.currentTimeMillis();
        List markerIndices = this.markers.parallelStream().map(marker -> this.markerInds.get(marker)).collect(Collectors.toList());
        System.out.println("Read and mapped markers: " + (System.currentTimeMillis() - s) + " (ms)");
        this.reader = HDF5Factory.openForReading((File)this.hdf5File);
        s = System.currentTimeMillis();
        String[] stateTable = this.reader.readStringArray(STATE_TABLE);
        System.out.println("Read statetable: " + (System.currentTimeMillis() - s) + " (ms)");
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF8")));){
            writer.println("# fjFile = GENOTYPE");
            if (!headerLines.isEmpty()) {
                writer.print(headerLines);
            }
            writer.println(this.markers.parallelStream().collect(Collectors.joining("\t", "Accession/Marker\t", "")));
            s = System.currentTimeMillis();
            this.lines.stream().forEachOrdered(lineName -> {
                byte[] genotypes = this.reader.int8().readMatrixBlock(DATA, 1, this.markerInds.size(), (long)this.lineInds.get(lineName).intValue(), 0L)[0];
                String outputGenotypes = this.createGenotypeFlatFileString((String)lineName, genotypes, markerIndices, stateTable);
                writer.println(outputGenotypes);
            });
            System.out.println("Output lines to genotype file: " + (System.currentTimeMillis() - s) + " (ms)");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reader.close();
        System.out.println();
        System.out.println("HDF5 file converted to Flapjack genotype format");
    }

    private String createGenotypeFlatFileString(String lineName, byte[] genotypes, List<Integer> markerIndices, String[] stateTable) {
        return markerIndices.parallelStream().map(index -> genotypes[index]).map(allele -> stateTable[allele]).collect(Collectors.joining("\t", lineName + "\t", ""));
    }

    public LinkedHashSet<String> getKeptMarkers() {
        LinkedHashSet<String> keptMarkers = this.hdf5Markers;
        keptMarkers.retainAll(this.markers);
        return keptMarkers;
    }

    private static void printHelp() {
        System.out.println("Usage: hdf52fj <options>\n where valid options are:\n   -hdf5=<hdf5_file>                               (required input file)\n   -lines=<file_list_of_lines_one_per_line>        (required input file)\n   -markers=<file_list_of_markers_one_per_line>    (required input file)\n   -missing_filter=<true/false>                    (required input string)\n   -heterozygous_filter=<true/false>               (required input string)\n   -genotypes=<genotypes_file>                     (required output file)\n");
    }
}

