/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.dialog.DuplicateMarkersDialog;
import jhi.flapjack.io.ChromosomeMapImporter;
import jhi.flapjack.io.GenotypeDataImporter;
import jhi.flapjack.io.Hdf5ChromosomeMapImporter;
import jhi.flapjack.io.Hdf5GenotypeDataImporter;
import jhi.flapjack.io.IGenotypeImporter;
import jhi.flapjack.io.IMapImporter;
import jhi.flapjack.io.PostImportOperations;
import jhi.flapjack.io.brapi.BrapiClient;
import jhi.flapjack.io.brapi.BrapiGenotypeImporter;
import jhi.flapjack.io.brapi.BrapiMapImporter;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;

public class DataImporter
extends SimpleJob {
    public static final int IMPORT_BRAPI = 1;
    public static final int IMPORT_CLASSIC = 0;
    public static final int IMPORT_HDF5 = 2;
    private DataSet dataSet = new DataSet();
    private IMapImporter mapImporter;
    private File genoFile;
    private IGenotypeImporter genoImporter;
    private File hdf5File;
    private BrapiClient client;
    private long totalBytes;
    private boolean usePrefs;

    public DataImporter(File mapFile, File genoFile, boolean usePrefs) {
        this.genoFile = genoFile;
        this.usePrefs = usePrefs;
        if (mapFile != null) {
            this.totalBytes += mapFile.length();
        }
        this.totalBytes = genoFile.length();
        this.maximum = 5555;
        this.mapImporter = new ChromosomeMapImporter(mapFile, this.dataSet);
    }

    public DataImporter(BrapiClient client, boolean usePrefs) {
        this.client = client;
        this.usePrefs = usePrefs;
        this.mapImporter = new BrapiMapImporter(client, this.dataSet);
    }

    public DataImporter(File hdf5File, boolean usePrefs) {
        this.hdf5File = hdf5File;
        this.usePrefs = usePrefs;
        this.mapImporter = new Hdf5ChromosomeMapImporter(hdf5File, this.dataSet);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void runJob(int jobIndex) throws Exception {
        long s = System.currentTimeMillis();
        this.mapImporter.importMap();
        this.setupGenotypeImport();
        this.genoImporter.importGenotypeData();
        this.genoImporter.cleanUp();
        if (Prefs.ioMakeAllChromosome) {
            this.dataSet.createSuperChromosome(RB.getString((String)"io.DataImporter.allChromosomes"));
        }
        if (this.okToRun) {
            PostImportOperations pio = new PostImportOperations(this.dataSet);
            File imported = this.genoFile != null ? this.genoFile : this.hdf5File;
            pio.setName(imported);
            pio.collapseHomzEncodedAsHet();
            if (Prefs.ioHeteroCollapse) {
                pio.optimizeStateTable();
            }
            pio.createDefaultView();
        }
        System.gc();
        if (Prefs.warnDuplicateMarkers && this.okToRun) {
            this.displayDuplicates();
        }
        System.out.println("Time taken: " + (System.currentTimeMillis() - s) + " ms");
    }

    private void setupGenotypeImport() {
        switch (Prefs.guiImportType) {
            case 0: {
                if (this.usePrefs) {
                    this.genoImporter = new GenotypeDataImporter(this.genoFile, this.dataSet, this.mapImporter.getMarkersHashMap(), Prefs.ioMissingData, Prefs.ioUseHetSep, Prefs.ioHeteroSeparator, Prefs.ioTransposed);
                    break;
                }
                this.genoImporter = new GenotypeDataImporter(this.genoFile, this.dataSet, this.mapImporter.getMarkersHashMap(), "-", true, "/", Prefs.ioTransposed);
                break;
            }
            case 1: {
                BrapiMapImporter bMapImporter = (BrapiMapImporter)this.mapImporter;
                this.genoImporter = new BrapiGenotypeImporter(this.client, this.dataSet, bMapImporter.getMarkersHashMap(), bMapImporter.getMarkersByName(), Prefs.ioMissingData, Prefs.ioUseHetSep, Prefs.ioHeteroSeparator);
                break;
            }
            case 2: {
                ArrayList<Integer> markerChromosomes = ((Hdf5ChromosomeMapImporter)this.mapImporter).markerChromosomes();
                this.genoImporter = new Hdf5GenotypeDataImporter(this.hdf5File, this.dataSet, this.mapImporter.getMarkersHashMap(), markerChromosomes);
                break;
            }
        }
    }

    private void displayDuplicates() {
        if (this.mapImporter.getDuplicates().size() == 0) {
            return;
        }
        Runnable r = () -> new DuplicateMarkersDialog(this.mapImporter.getDuplicates());
        try {
            SwingUtilities.invokeAndWait(r);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public int getMaximum() {
        return 5555;
    }

    public int getValue() {
        long mapBytes = this.mapImporter.getBytesRead();
        long genoBytes = this.genoImporter.getBytesRead();
        long bytesRead = mapBytes + genoBytes;
        return Math.round((float)bytesRead / (float)this.totalBytes * 5555.0f);
    }

    public String getMessage() {
        NumberFormat nf = NumberFormat.getInstance();
        return RB.format((String)"io.DataImporter.message", (Object[])new Object[]{nf.format(this.dataSet.countChromosomeMaps()), nf.format(this.mapImporter.getMarkerCount()), nf.format(this.genoImporter.getLineCount()), nf.format(this.genoImporter.getMarkerCount())});
    }

    public void cancelJob() {
        super.cancelJob();
        this.mapImporter.cancelImport();
        this.genoImporter.cancelImport();
    }
}

