/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DatabaseInputStream
extends InputStream {
    private PreparedStatement ps;
    private ResultSet rs;
    private int blobColumn;
    protected byte[] buf = new byte[0];
    protected int pos;
    protected int count;

    public DatabaseInputStream(PreparedStatement ps, int blobColumn) {
        this.ps = ps;
        this.blobColumn = blobColumn;
    }

    private void queryDatabase() throws IOException {
        try {
            if (this.rs == null) {
                this.rs = this.ps.executeQuery();
            }
            if (this.rs.next()) {
                this.buf = this.rs.getBytes(this.blobColumn);
                this.pos = 0;
                this.count = this.buf.length;
            } else {
                this.rs.close();
                this.pos = -1;
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public synchronized int read() {
        if (this.pos >= this.buf.length) {
            try {
                this.queryDatabase();
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        int copied = 0;
        while (len > 0) {
            if (this.pos >= this.buf.length) {
                this.queryDatabase();
            }
            if (this.pos == -1) break;
            int bytes = this.buf.length - this.pos > len ? len : this.buf.length - this.pos;
            System.arraycopy(this.buf, this.pos, b, off, bytes);
            copied += bytes;
            this.pos += bytes;
            off += bytes;
            len -= bytes;
        }
        return copied > 0 ? copied : -1;
    }

    @Override
    public synchronized long skip(long n) {
        long k = this.count - this.pos;
        if (n < k) {
            k = n < 0L ? 0L : n;
        }
        this.pos = (int)((long)this.pos + k);
        return k;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
        throw new RuntimeException();
    }

    @Override
    public synchronized void reset() {
        throw new RuntimeException();
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

