/*
 * Decompiled with CFR 0.152.
 */
package org.ggf.drmaa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.FileTransferMode;
import org.ggf.drmaa.InvalidAttributeFormatException;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.PartialTimestamp;
import org.ggf.drmaa.PartialTimestampFormat;
import org.ggf.drmaa.UnsupportedAttributeException;

public class SimpleJobTemplate
implements JobTemplate,
Serializable {
    private String toString = null;
    private Set allPropertyNames = null;
    private boolean modified = true;
    protected String remoteCommand = null;
    protected List args = null;
    protected int jobSubmissionState = 1;
    protected Map jobEnvironment = null;
    protected String workingDirectory = null;
    protected String jobCategory = null;
    protected String nativeSpecification = null;
    protected Set email = null;
    protected boolean blockEmail = false;
    protected PartialTimestamp startTime = null;
    protected String jobName = null;
    protected String inputPath = null;
    protected String outputPath = null;
    protected String errorPath = null;
    protected boolean joinFiles = false;

    public void setRemoteCommand(String remoteCommand) throws DrmaaException {
        this.remoteCommand = remoteCommand;
        this.modified = true;
    }

    public String getRemoteCommand() throws DrmaaException {
        return this.remoteCommand;
    }

    public void setArgs(List args) throws DrmaaException {
        this.args = args != null ? new ArrayList(args) : null;
        this.modified = true;
    }

    public List getArgs() throws DrmaaException {
        List returnValue = null;
        if (this.args != null) {
            returnValue = Collections.unmodifiableList(this.args);
        }
        return returnValue;
    }

    public void setJobSubmissionState(int state) throws DrmaaException {
        if (state != 1 && state != 0) {
            throw new IllegalArgumentException("Invalid state");
        }
        this.jobSubmissionState = state;
        this.modified = true;
    }

    public int getJobSubmissionState() throws DrmaaException {
        return this.jobSubmissionState;
    }

    public void setJobEnvironment(Map env) throws DrmaaException {
        this.jobEnvironment = env != null ? new HashMap(env) : null;
        this.modified = true;
    }

    public Map getJobEnvironment() throws DrmaaException {
        Map returnValue = null;
        if (this.jobEnvironment != null) {
            returnValue = Collections.unmodifiableMap(this.jobEnvironment);
        }
        return returnValue;
    }

    public void setWorkingDirectory(String wd) throws DrmaaException {
        if (wd.indexOf("$drmaa_hd_ph$") > 0) {
            throw new InvalidAttributeFormatException("$drmaa_hd_ph$ may only appear at the beginning of the path.");
        }
        if (wd.indexOf("$drmaa_wd_ph$") >= 0) {
            throw new InvalidAttributeFormatException("$drmaa_wd_ph$ may not be used in the workingDirectory path.");
        }
        this.workingDirectory = wd;
        this.modified = true;
    }

    public String getWorkingDirectory() throws DrmaaException {
        return this.workingDirectory;
    }

    public void setJobCategory(String category) throws DrmaaException {
        this.jobCategory = category;
        this.modified = true;
    }

    public String getJobCategory() throws DrmaaException {
        return this.jobCategory;
    }

    public void setNativeSpecification(String spec) throws DrmaaException {
        this.nativeSpecification = spec;
        this.modified = true;
    }

    public String getNativeSpecification() throws DrmaaException {
        return this.nativeSpecification;
    }

    public void setEmail(Set email) throws DrmaaException {
        this.email = email != null ? new HashSet(email) : null;
        this.modified = true;
    }

    public Set getEmail() throws DrmaaException {
        Set returnValue = null;
        if (this.email != null) {
            returnValue = Collections.unmodifiableSet(this.email);
        }
        return returnValue;
    }

    public void setBlockEmail(boolean blockEmail) throws DrmaaException {
        this.blockEmail = blockEmail;
        this.modified = true;
    }

    public boolean getBlockEmail() throws DrmaaException {
        return this.blockEmail;
    }

    public void setStartTime(PartialTimestamp startTime) throws DrmaaException {
        if (startTime != null) {
            if (startTime.getTimeInMillis() < System.currentTimeMillis()) {
                throw new IllegalArgumentException("Start time is in the past.");
            }
            this.startTime = startTime;
        } else {
            startTime = null;
        }
        this.modified = true;
    }

    public PartialTimestamp getStartTime() throws DrmaaException {
        if (this.startTime != null) {
            return (PartialTimestamp)this.startTime.clone();
        }
        return null;
    }

    public void setJobName(String name) throws DrmaaException {
        this.jobName = name;
        this.modified = true;
    }

    public String getJobName() throws DrmaaException {
        return this.jobName;
    }

    public void setInputPath(String inputPath) throws DrmaaException {
        this.checkPath(inputPath);
        this.inputPath = inputPath;
        this.modified = true;
    }

    public String getInputPath() throws DrmaaException {
        return this.inputPath;
    }

    public void setOutputPath(String outputPath) throws DrmaaException {
        this.checkPath(outputPath);
        this.outputPath = outputPath;
        this.modified = true;
    }

    public String getOutputPath() throws DrmaaException {
        return this.outputPath;
    }

    public void setErrorPath(String errorPath) throws DrmaaException {
        this.checkPath(errorPath);
        this.errorPath = errorPath;
        this.modified = true;
    }

    public String getErrorPath() throws DrmaaException {
        return this.errorPath;
    }

    public void setJoinFiles(boolean join) throws DrmaaException {
        this.joinFiles = join;
        this.modified = true;
    }

    public boolean getJoinFiles() throws DrmaaException {
        return this.joinFiles;
    }

    public void setTransferFiles(FileTransferMode mode) throws DrmaaException {
        throw new UnsupportedAttributeException("The transferFiles attribute is not supported.");
    }

    public FileTransferMode getTransferFiles() throws DrmaaException {
        throw new UnsupportedAttributeException("The transferFiles attribute is not supported.");
    }

    public void setDeadlineTime(PartialTimestamp deadline) throws DrmaaException {
        throw new UnsupportedAttributeException("The deadlineTime attribute is not supported.");
    }

    public PartialTimestamp getDeadlineTime() throws DrmaaException {
        throw new UnsupportedAttributeException("The deadlineTime attribute is not supported.");
    }

    public void setHardWallclockTimeLimit(long hardWallclockLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The hardWallclockTimeLimit attribute is not supported.");
    }

    public long getHardWallclockTimeLimit() throws DrmaaException {
        throw new UnsupportedAttributeException("The hardWallclockTimeLimit attribute is not supported.");
    }

    public void setSoftWallclockTimeLimit(long softWallclockLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The softWallclockTimeLimit attribute is not supported.");
    }

    public long getSoftWallclockTimeLimit() throws DrmaaException {
        throw new UnsupportedAttributeException("The softWallclockTimeLimit attribute is not supported.");
    }

    public void setHardRunDurationLimit(long hardRunLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The hardRunDurationLimit attribute is not supported.");
    }

    public long getHardRunDurationLimit() throws DrmaaException {
        throw new UnsupportedAttributeException("The hardRunDurationLimit attribute is not supported.");
    }

    public void setSoftRunDurationLimit(long softRunLimit) throws DrmaaException {
        throw new UnsupportedAttributeException("The softRunDurationLimit attribute is not supported.");
    }

    public long getSoftRunDurationLimit() throws DrmaaException {
        throw new UnsupportedAttributeException("The softRunDurationLimit attribute is not supported.");
    }

    public Set getAttributeNames() throws DrmaaException {
        if (this.allPropertyNames == null) {
            this.allPropertyNames = new HashSet();
            SimpleJobTemplate.addRequiredNames(this.allPropertyNames);
            this.allPropertyNames.addAll(this.getOptionalAttributeNames());
        }
        return this.allPropertyNames;
    }

    protected Set getOptionalAttributeNames() {
        return Collections.EMPTY_SET;
    }

    private static final void addRequiredNames(Set names) {
        names.add("args");
        names.add("blockEmail");
        names.add("email");
        names.add("errorPath");
        names.add("inputPath");
        names.add("jobCategory");
        names.add("jobEnvironment");
        names.add("jobName");
        names.add("jobSubmissionState");
        names.add("joinFiles");
        names.add("nativeSpecification");
        names.add("outputPath");
        names.add("remoteCommand");
        names.add("startTime");
        names.add("workingDirectory");
    }

    private void checkPath(String path) throws IllegalArgumentException {
        if (path == null) {
            return;
        }
        if (path.indexOf("$drmaa_hd_ph$") > 0) {
            throw new IllegalArgumentException("$drmaa_hd_ph$ may only appear at the beginning of the path.");
        }
        if (path.indexOf("$drmaa_wd_ph$") > 0) {
            throw new IllegalArgumentException("$drmaa_wd_ph$ may only appear at the beginning of the path.");
        }
    }

    protected void modified() {
        this.modified = true;
    }

    public String toString() {
        if (this.modified) {
            boolean error = false;
            boolean firstProperty = true;
            StringBuffer out = new StringBuffer();
            List args = null;
            try {
                args = this.getArgs();
            }
            catch (DrmaaException e) {
                out.append("{args = <ERROR>}");
                firstProperty = false;
                error = true;
            }
            if (args != null && args.size() > 0) {
                Iterator i = args.iterator();
                boolean firstArg = true;
                out.append("{args = ");
                while (i.hasNext()) {
                    if (firstArg) {
                        firstArg = false;
                    } else {
                        out.append(", ");
                    }
                    out.append("\"");
                    out.append(i.next());
                    out.append("\"");
                }
                out.append("}");
                firstProperty = false;
            }
            if (!firstProperty) {
                out.append(" ");
            }
            out.append("{blockEmail = ");
            try {
                out.append(Boolean.toString(this.getBlockEmail()));
            }
            catch (DrmaaException e) {
                out.append("<ERROR>");
                error = true;
            }
            out.append("}");
            try {
                if (this.getDeadlineTime() != null) {
                    PartialTimestampFormat ptf = new PartialTimestampFormat();
                    out.append(" {deadlineTime = ");
                    out.append(ptf.format(this.getDeadlineTime()));
                    out.append("}");
                }
            }
            catch (UnsupportedAttributeException e) {
            }
            catch (DrmaaException e) {
                out.append(" {deadlineTime = <ERROR>}");
                error = true;
            }
            Set email = null;
            try {
                email = this.getEmail();
            }
            catch (DrmaaException e) {
                out.append(" {email = <ERROR>}");
                error = true;
            }
            if (email != null && email.size() > 0) {
                Iterator i = email.iterator();
                boolean firstEmail = true;
                out.append(" {email = ");
                while (i.hasNext()) {
                    if (firstEmail) {
                        firstEmail = false;
                    } else {
                        out.append(", ");
                    }
                    out.append("\"");
                    out.append(i.next());
                    out.append("\"");
                }
                out.append("}");
            }
            try {
                if (this.getErrorPath() != null) {
                    out.append(" {errorPath = ");
                    out.append(this.getErrorPath());
                    out.append("}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {errorPath = <ERROR>}");
                error = true;
            }
            try {
                if (this.getHardRunDurationLimit() != 0L) {
                    out.append(" {hardRunDurationLimit = ");
                    out.append(this.getHardRunDurationLimit());
                    out.append("ms}");
                }
            }
            catch (UnsupportedAttributeException e) {
            }
            catch (DrmaaException e) {
                out.append(" {hardRunDurationLimit = <ERROR>}");
                error = true;
            }
            try {
                if (this.getHardWallclockTimeLimit() != 0L) {
                    out.append(" {hardWallclockTimeLimit = ");
                    out.append(this.getHardWallclockTimeLimit());
                    out.append("ms}");
                }
            }
            catch (UnsupportedAttributeException e) {
            }
            catch (DrmaaException e) {
                out.append(" {hardWallclockTimeLimit = <ERROR>}");
                error = true;
            }
            try {
                if (this.getInputPath() != null) {
                    out.append(" {inputPath = ");
                    out.append(this.getInputPath());
                    out.append("}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {inputPath = <ERROR>}");
                error = true;
            }
            try {
                if (this.getJobCategory() != null) {
                    out.append(" {jobCategory = ");
                    out.append(this.getJobCategory());
                    out.append("}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {jobCategory = <ERROR>}");
                error = true;
            }
            Map env = null;
            try {
                env = this.getJobEnvironment();
            }
            catch (DrmaaException e) {
                out.append(" {jobEnvironment = <ERROR>}");
                error = true;
            }
            if (env != null && env.size() > 0) {
                Iterator i = env.keySet().iterator();
                boolean firstEnv = true;
                out.append(" {jobEnvironment = ");
                while (i.hasNext()) {
                    String entry = (String)i.next();
                    if (firstEnv) {
                        firstEnv = false;
                    } else {
                        out.append(", ");
                    }
                    out.append("[\"");
                    out.append(entry);
                    out.append("\" = \"");
                    out.append(env.get(entry));
                    out.append("\"]");
                }
                out.append("}");
            }
            try {
                if (this.getJobName() != null) {
                    out.append(" {jobName = ");
                    out.append(this.getJobName());
                    out.append("}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {jobName = <ERROR>}");
                error = true;
            }
            out.append(" {jobSubmissionState = ");
            try {
                if (this.getJobSubmissionState() == 0) {
                    out.append("HOLD_STATE}");
                } else {
                    out.append("ACTIVE_STATE}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {jobSubmissionState = <ERROR>}");
                error = true;
            }
            out.append(" {joinFiles = ");
            try {
                out.append(Boolean.toString(this.getJoinFiles()));
            }
            catch (DrmaaException e) {
                out.append(" {joinFiles = <ERROR>}");
                error = true;
            }
            out.append("}");
            try {
                if (this.getNativeSpecification() != null) {
                    out.append(" {nativeSpecification = \"");
                    out.append(this.getNativeSpecification());
                    out.append("\"}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {nativeSpecification = <ERROR>}");
                error = true;
            }
            try {
                if (this.getOutputPath() != null) {
                    out.append(" {outputPath = ");
                    out.append(this.getOutputPath());
                    out.append("}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {outputPath = <ERROR>}");
                error = true;
            }
            try {
                if (this.getRemoteCommand() != null) {
                    out.append(" {remoteCommand = ");
                    out.append(this.getRemoteCommand());
                    out.append("}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {remoteCommand = <ERROR>}");
                error = true;
            }
            try {
                if (this.getSoftRunDurationLimit() != 0L) {
                    out.append(" {softRunDurationLimit = ");
                    out.append(this.getSoftRunDurationLimit());
                    out.append("ms}");
                }
            }
            catch (UnsupportedAttributeException e) {
            }
            catch (DrmaaException e) {
                out.append(" {softRunDurationLimit = <ERROR>}");
                error = true;
            }
            try {
                if (this.getSoftWallclockTimeLimit() != 0L) {
                    out.append(" {softWallclockTimeLimit = ");
                    out.append(this.getSoftWallclockTimeLimit());
                    out.append("ms}");
                }
            }
            catch (UnsupportedAttributeException e) {
            }
            catch (DrmaaException e) {
                out.append(" {softWallclockTimeLimit = <ERROR>}");
                error = true;
            }
            try {
                if (this.getStartTime() != null) {
                    PartialTimestampFormat ptf = new PartialTimestampFormat();
                    out.append(" {startTime = \"");
                    out.append(ptf.format(this.getStartTime()));
                    out.append("\"}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {startTime = <ERROR>}");
                error = true;
            }
            try {
                if (this.getTransferFiles() != null) {
                    out.append(" {transferFiles = \"");
                    out.append(this.getTransferFiles().toString());
                    out.append("\"}");
                }
            }
            catch (UnsupportedAttributeException e) {
            }
            catch (DrmaaException e) {
                out.append(" {transferFiles = <ERROR>}");
                error = true;
            }
            try {
                if (this.getWorkingDirectory() != null) {
                    out.append(" {workingDirectory = ");
                    out.append(this.getWorkingDirectory());
                    out.append("}");
                }
            }
            catch (DrmaaException e) {
                out.append(" {workingDirectory = <ERROR>}");
                error = true;
            }
            this.toString = out.toString();
            this.modified = error;
        }
        return this.toString;
    }
}

