/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.colors.ColorScheme;

class OverviewCanvas
extends JPanel {
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private Canvas2D viewCanvas = new Canvas2D();
    private float boxX1;
    private float boxY1;
    private float boxX2;
    private float boxY2;
    private BufferFactory bufferFactory = null;
    private BufferedImage image = null;
    private int w;
    private int h;

    public OverviewCanvas(GenotypePanel gPanel, GenotypeCanvas canvas) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.setLayout(new BorderLayout());
        this.setBackground((Color)UIManager.get("Tree.background"));
        this.add(this.viewCanvas);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OverviewCanvas.this.createImage();
            }
        });
    }

    void updateOverviewSelectionBox(int xIndex, int xW, int yIndex, int yH) {
        if (this.bufferFactory == null) {
            return;
        }
        this.boxX1 = this.bufferFactory.xScale * (float)xIndex;
        this.boxY1 = this.bufferFactory.yScale * (float)yIndex;
        this.boxX2 = this.boxX1 + (float)xW * this.bufferFactory.xScale;
        if (xW > this.canvas.boxTotalX || this.boxX2 > (float)this.viewCanvas.getWidth()) {
            this.boxX2 = this.viewCanvas.getWidth();
        }
        this.boxY2 = this.boxY1 + (float)yH * this.bufferFactory.yScale;
        if (yH > this.canvas.boxTotalY || this.boxY2 > (float)this.viewCanvas.getHeight()) {
            this.boxY2 = this.viewCanvas.getHeight();
        }
        this.repaint();
    }

    void createImage() {
        this.w = this.viewCanvas.getSize().width;
        this.h = this.viewCanvas.getSize().height;
        if (this.gPanel == null || !this.isVisible()) {
            return;
        }
        this.image = null;
        if (this.bufferFactory != null) {
            this.bufferFactory.killMe = true;
        }
        this.bufferFactory = new BufferFactory(this.w > 0 ? this.w : 1, this.h > 0 ? this.h : 1, false);
        this.repaint();
    }

    public BufferedImage exportImage(int w, int h) {
        BufferFactory tmpFactory = new BufferFactory(w, h, true);
        tmpFactory.run();
        return tmpFactory.buffer;
    }

    private void bufferAvailable(BufferedImage image) {
        this.image = image;
        this.gPanel.forceOverviewUpdate();
    }

    private class BufferFactory
    extends Thread {
        private ColorScheme cScheme;
        private BufferedImage buffer;
        boolean killMe = false;
        boolean isExporting = false;
        private int w;
        private int h;
        private int boxTotalX;
        private int boxTotalY;
        private float xScale;
        private float yScale;

        BufferFactory(int w, int h, boolean isExporting) {
            this.w = w;
            this.h = h;
            this.isExporting = isExporting;
            this.boxTotalX = ((OverviewCanvas)OverviewCanvas.this).canvas.boxTotalX;
            this.boxTotalY = ((OverviewCanvas)OverviewCanvas.this).canvas.boxTotalY;
            this.cScheme = ((OverviewCanvas)OverviewCanvas.this).canvas.cScheme;
            if (!isExporting) {
                this.start();
            }
        }

        @Override
        public void run() {
            this.setPriority(1);
            this.setName("OverviewCanvas BufferFactory");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.killMe) {
                return;
            }
            try {
                this.createBuffer();
            }
            catch (Exception e) {
                System.out.println("OverviewCanvas: " + e);
            }
        }

        private void createBuffer() {
            try {
                this.buffer = this.isExporting ? new BufferedImage(this.w, this.h, 1) : new BufferedImage(this.w, this.h, 13);
            }
            catch (Throwable t) {
                return;
            }
            this.xScale = (float)this.boxTotalX / (float)this.w;
            this.yScale = (float)this.boxTotalY / (float)this.h;
            Graphics2D g = this.buffer.createGraphics();
            g.setColor(Prefs.visColorBackground);
            g.fillRect(0, 0, this.w, this.h);
            for (int y = 0; y < this.h && !this.killMe; ++y) {
                for (int x = 0; x < this.w && !this.killMe; ++x) {
                    int dataX = (int)((float)x * this.xScale);
                    int dataY = (int)((float)y * this.yScale);
                    try {
                        g.setColor(this.cScheme.getColor(dataY, dataX));
                        g.drawLine(x, y, x, y);
                        continue;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
            this.xScale = (float)this.w / (float)this.boxTotalX;
            this.yScale = (float)this.h / (float)this.boxTotalY;
            if (!this.killMe && !this.isExporting) {
                OverviewCanvas.this.bufferAvailable(this.buffer);
            }
        }
    }

    private class Canvas2D
    extends JPanel {
        Canvas2D() {
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Canvas2D.this.processMouse(e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    Canvas2D.this.processMouse(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Canvas2D.this.processMouse(e);
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    Canvas2D.this.processMouse(e);
                }
            });
        }

        private void processMouse(MouseEvent e) {
            if (OverviewCanvas.this.gPanel == null) {
                return;
            }
            int x = e.getX() - (int)((OverviewCanvas.this.boxX2 - OverviewCanvas.this.boxX1) / 2.0f);
            int y = e.getY() - (int)((OverviewCanvas.this.boxY2 - OverviewCanvas.this.boxY1) / 2.0f);
            int xIndex = (int)((float)x / OverviewCanvas.this.bufferFactory.xScale);
            int yIndex = (int)((float)y / OverviewCanvas.this.bufferFactory.yScale);
            OverviewCanvas.this.gPanel.getController().moveTo(yIndex, xIndex, false);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (OverviewCanvas.this.image == null) {
                return;
            }
            g.drawImage(OverviewCanvas.this.image, 0, 0, null);
            ((Graphics2D)g).setPaint(new Color(255, 255, 255, 50));
            g.fillRect(0, 0, OverviewCanvas.this.w, OverviewCanvas.this.h);
            int cR = Prefs.visColorOverviewFill.getRed();
            int cG = Prefs.visColorOverviewFill.getGreen();
            int cB = Prefs.visColorOverviewFill.getBlue();
            ((Graphics2D)g).setPaint(new Color(cR, cG, cB, 50));
            int boxW = Math.round(OverviewCanvas.this.boxX2 - OverviewCanvas.this.boxX1) - 1;
            int boxH = Math.round(OverviewCanvas.this.boxY2 - OverviewCanvas.this.boxY1) - 1;
            g.fillRect(Math.round(OverviewCanvas.this.boxX1), Math.round(OverviewCanvas.this.boxY1), boxW, boxH);
            g.setColor(Prefs.visColorOverviewOutline);
            g.drawRect(Math.round(OverviewCanvas.this.boxX1), Math.round(OverviewCanvas.this.boxY1), boxW, boxH);
        }
    }
}

