/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class FileUtils {
    public static String readFile(File file) throws IOException {
        int n;
        StringBuilder sb = new StringBuilder((int)file.length());
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            sb.append(new String(b, 0, n));
        }
        in.close();
        return sb.toString();
    }

    public static void writeFile(File file, String str) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        out.write(str);
        ((Writer)out).close();
    }

    public static void writeFile(File file, InputStream inputStream) throws IOException {
        int n;
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        BufferedInputStream in = new BufferedInputStream(inputStream);
        byte[] b = new byte[4096];
        while ((n = in.read(b)) != -1) {
            out.write(b, 0, n);
        }
        in.close();
        out.close();
    }

    public static void copyFile(File src, File dest, boolean move) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        FileUtils.writeFile(dest, in);
        if (move) {
            src.delete();
        }
    }

    public static void emptyDirectory(File dir, boolean delete) {
        if (!dir.isDirectory()) {
            return;
        }
        try {
            File[] files;
            for (File f : files = dir.listFiles()) {
                if (f.isDirectory()) {
                    FileUtils.emptyDirectory(f, delete);
                }
                f.delete();
            }
            if (delete) {
                dir.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void downloadFile(URL url, File file) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        FileUtils.writeFile(file, connection.getInputStream());
    }

    public static File getFile(File root, Object ... args) {
        for (Object obj : args) {
            root = new File(root, obj.toString());
        }
        return root;
    }

    public static long getZipfileEntriesSize(String zipFilePath) {
        long totalSize = 0L;
        try {
            ZipFile zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                long size = entry.getSize();
                totalSize += size;
            }
            zipFile.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return totalSize;
    }

    public static long getZipfileEntriesSize(InputStream fileInputStream) {
        long totalSize = 0L;
        try {
            ZipInputStream zipStream = new ZipInputStream(fileInputStream);
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                long size = entry.getSize();
                totalSize += size;
                entry = zipStream.getNextEntry();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return totalSize;
    }

    public static int countLines(File file, int bufferSize) throws IOException {
        InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
        int lineCount = 0;
        char[] buffer = new char[bufferSize];
        int charsRead = reader.read(buffer);
        while (charsRead >= 0) {
            for (int charIndex = 0; charIndex < charsRead; ++charIndex) {
                if (buffer[charIndex] != '\n') continue;
                ++lineCount;
            }
            charsRead = reader.read(buffer);
        }
        ((Reader)reader).close();
        return lineCount;
    }

    public static File getTempDirectory() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static File getTempUserDirectory(String appName) {
        String username = System.getProperty("user.name");
        appName = appName + "-" + username;
        File appDirectory = new File(FileUtils.getTempDirectory(), appName);
        appDirectory.mkdirs();
        return appDirectory;
    }
}

