/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jhi.flapjack.data.XMLRoot;

public class AlleleState
extends XMLRoot {
    private String[] states;
    private boolean isHomozygous = true;

    public AlleleState() {
    }

    public AlleleState(String rawData, String hetSepStr) {
        rawData = new String(rawData.toUpperCase());
        if (!hetSepStr.isEmpty()) {
            this.states = rawData.split(hetSepStr);
        } else {
            this.states = new String[rawData.length()];
            for (int i = 0; i < this.states.length; ++i) {
                this.states[i] = "" + rawData.charAt(i);
            }
        }
        if (this.states.length > 1) {
            this.isHomozygous = false;
        }
    }

    void validate() throws NullPointerException {
        if (this.states == null) {
            throw new NullPointerException();
        }
    }

    public String[] getStates() {
        return this.states;
    }

    public void setStates(String[] states) {
        this.states = states;
    }

    public boolean isHomozygous() {
        return this.isHomozygous;
    }

    public void setHomozygous(boolean isHomozygous) {
        this.isHomozygous = isHomozygous;
    }

    public String toString() {
        return Stream.of(this.states).collect(Collectors.joining("/"));
    }

    public String homzAllele() {
        if (!this.isHomozygous()) {
            throw new IllegalStateException("Attempted to get a homozygous state for an AlleleState that is heterozygous.");
        }
        return this.states[0];
    }

    public String getState(int index) {
        return this.states[index];
    }

    public boolean matches(AlleleState other) {
        String[] otherStates = other.states;
        if (this.states.length != otherStates.length) {
            return false;
        }
        for (int i = 0; i < this.states.length; ++i) {
            if (this.countState(this.states[i]) == other.countState(this.states[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isSameHomzAs(AlleleState other) {
        if (!this.isHomozygous() || !other.isHomozygous) {
            return false;
        }
        return this.states[0].equals(other.states[0]);
    }

    private int countState(String allele) {
        int count = 0;
        for (String s : this.states) {
            if (!s.equals(allele)) continue;
            ++count;
        }
        return count;
    }

    public boolean isUnknown() {
        return this.states[0].isEmpty();
    }

    public boolean matchesAnyAllele(AlleleState other) {
        for (String a1 : this.states) {
            for (String a2 : other.states) {
                if (!a1.equals(a2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAllele(String allele, AlleleState other) {
        return Arrays.stream(other.states).anyMatch(allele::equals);
    }

    public boolean allelesContainedInParents(AlleleState parent1, AlleleState parent2) {
        for (String a1 : this.states) {
            if (this.hasAllele(a1, parent1) || this.hasAllele(a1, parent2)) continue;
            return false;
        }
        return true;
    }

    public String xmlGetRawData() {
        return this.toString();
    }

    public boolean isHomzEncodedAsHet() {
        if (this.isHomozygous) {
            return false;
        }
        String str = this.states[0];
        for (int i = 1; i < this.states.length; ++i) {
            if (this.states[i].equals(str)) continue;
            return false;
        }
        return true;
    }
}

