/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.ChallengeMessage;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Reference;

public final class ChallengeRequest
extends ChallengeMessage {
    private volatile List<String> qualityOptions = null;
    private volatile List<Reference> domainRefs = null;
    private volatile boolean stale = false;

    public ChallengeRequest(ChallengeScheme scheme) {
        this(scheme, (String)null);
    }

    public ChallengeRequest(ChallengeScheme scheme, String realm) {
        super(scheme, realm);
    }

    public boolean equals(Object obj) {
        boolean result;
        boolean bl = result = obj == this;
        if (!result && obj instanceof ChallengeRequest) {
            ChallengeRequest that = (ChallengeRequest)obj;
            result = this.getParameters().equals(that.getParameters());
            if (result) {
                if (this.getRealm() != null) {
                    result = this.getRealm().equals(that.getRealm());
                } else {
                    boolean bl2 = result = that.getRealm() == null;
                }
                if (result) {
                    result = this.getScheme() != null ? this.getScheme().equals(that.getScheme()) : that.getScheme() == null;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Reference> getDomainRefs() {
        List<Reference> r = this.domainRefs;
        if (r == null) {
            ChallengeRequest challengeRequest = this;
            synchronized (challengeRequest) {
                r = this.domainRefs;
                if (r == null) {
                    this.domainRefs = r = new CopyOnWriteArrayList<Reference>();
                    this.domainRefs.add(new Reference("/"));
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getQualityOptions() {
        List<String> r = this.qualityOptions;
        if (r == null) {
            ChallengeRequest challengeRequest = this;
            synchronized (challengeRequest) {
                r = this.qualityOptions;
                if (r == null) {
                    this.qualityOptions = r = new CopyOnWriteArrayList<String>();
                    this.qualityOptions.add("auth");
                }
            }
        }
        return r;
    }

    public boolean isStale() {
        return this.stale;
    }

    public void setDomainRefs(List<Reference> domainRefs) {
        this.domainRefs = domainRefs;
    }

    public void setDomainUris(Collection<String> domainUris) {
        CopyOnWriteArrayList<Reference> domainRefs = null;
        if (domainUris != null) {
            domainRefs = new CopyOnWriteArrayList<Reference>();
            for (String domainUri : domainUris) {
                domainRefs.add(new Reference(domainUri));
            }
        }
        this.setDomainRefs(domainRefs);
    }

    public void setQualityOptions(List<String> qualityOptions) {
        this.qualityOptions = qualityOptions;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
    }
}

