/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Objects;

public class VcfToFJTabbedConverter {
    private File vcfFile;
    private File mapFile;
    private File genotypeFile;
    private static final int FIRST_ACCESSION_COL = 9;
    private static final int BUFFER_SIZE = 5000;
    private final ArrayList<String[]> buffer = new ArrayList(5000);
    private final ArrayList<File> fileCache = new ArrayList();
    private int cols;

    public static void main(String[] args) {
        VcfToFJTabbedConverter toGenotype = new VcfToFJTabbedConverter(args);
        toGenotype.convert();
        System.exit(0);
    }

    private VcfToFJTabbedConverter(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-genotypes=")) {
                this.genotypeFile = new File(arg.substring(11));
            }
            if (arg.startsWith("-map=")) {
                this.mapFile = new File(arg.substring(5));
            }
            if (!arg.startsWith("-vcf=")) continue;
            this.vcfFile = new File(arg.substring(5));
        }
        if (this.genotypeFile == null || this.mapFile == null || this.vcfFile == null) {
            VcfToFJTabbedConverter.printHelp();
        }
    }

    public VcfToFJTabbedConverter(File vcfFile, File mapFile, File genotypeFile) {
        this.vcfFile = vcfFile;
        this.mapFile = mapFile;
        this.genotypeFile = genotypeFile;
    }

    public void convert() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.vcfFile));
             PrintWriter mapWriter = new PrintWriter(this.mapFile);){
            String line;
            mapWriter.println("# fjFile = MAP");
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("##")) continue;
                if (line.startsWith("#CHROM")) {
                    String[] accessions = this.getAccessions(line);
                    this.buffer.add(accessions);
                    this.cols = accessions.length;
                    this.initFileCache();
                    continue;
                }
                String[] markerData = line.split("\t", -1);
                String markerName = markerData[0].substring(3) + "_" + markerData[1];
                String chrName = markerData[0].substring(3);
                String markerPos = markerData[1];
                mapWriter.println(markerName + "\t" + chrName + "\t" + markerPos);
                String[] genotypes = new String[markerData.length - 9];
                genotypes[0] = markerName;
                for (int i = 1; i < genotypes.length; ++i) {
                    genotypes[i] = this.getGenotype(markerData[i + 9], markerData[3], markerData[4]);
                }
                this.buffer.add(genotypes);
                if (this.buffer.size() != 5000) continue;
                this.writeCache();
            }
            this.writeCache();
            this.writeData();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private String[] getAccessions(String line) {
        String[] headers = line.split("\t", -1);
        String[] accessions = new String[headers.length - 9];
        accessions[0] = "Accession/Marker";
        System.arraycopy(headers, 10, accessions, 1, accessions.length - 1);
        return accessions;
    }

    private String getGenotype(String cell, String ref, String alt) {
        String[] encoding = cell.split(":")[0].split("/");
        if (encoding.length == 2) {
            String allele1 = this.getAllele(encoding[0], ref, alt);
            String allele2 = this.getAllele(encoding[1], ref, alt);
            if (allele1.length() <= 1 && allele2.length() <= 1) {
                if (allele1.isEmpty()) {
                    return allele2;
                }
                if (allele2.isEmpty()) {
                    return allele1;
                }
                return Objects.equals(allele1, allele2) ? allele1 : allele1 + "/" + allele2;
            }
        }
        return "";
    }

    private String getAllele(String encoded, String ref, String alt) {
        String allele = "";
        try {
            int num = Integer.parseInt(encoded);
            allele = num == 0 ? ref : alt.split(",")[num - 1];
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return allele;
    }

    private void initFileCache() {
        this.fileCache.clear();
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        for (int i = 0; i < this.cols; ++i) {
            File file = new File(tmp, "_transpose_temp_" + i);
            file.delete();
            this.fileCache.add(file);
        }
    }

    private void writeCache() throws Exception {
        for (int i = 0; i < this.cols; ++i) {
            try (BufferedWriter out = new BufferedWriter(new FileWriter(this.fileCache.get(i), true));){
                for (String[] aBuffer : this.buffer) {
                    out.write(aBuffer[i] + "\t");
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        this.buffer.clear();
    }

    private void writeData() throws Exception {
        try (PrintWriter writer = new PrintWriter(this.genotypeFile);){
            writer.println("# fjFile = GENOTYPE");
            this.fileCache.forEach(file -> {
                try (BufferedReader reader = new BufferedReader(new FileReader((File)file));){
                    String line = reader.readLine();
                    writer.println(line.substring(0, line.length() - 1));
                    file.delete();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println("Usage: vcf2Genotype <options>\n where valid options are:\n   -vcf=<vcf_file>                (required input file)\n   -map=<map_file>                (required output file)\n   -genotypes=<genotype_file>     (required output file)\n");
        System.exit(1);
    }
}

