/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jhi.flapjack.data.Marker;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;

class MiniMapCanvas
extends JPanel {
    private GenotypePanel gPanel;
    private GenotypeCanvas canvas;
    private BufferFactory bufferFactory;
    private BufferedImage image;
    private int h = 11;
    private int w;

    MiniMapCanvas(GenotypePanel gPanel, GenotypeCanvas canvas) {
        this.gPanel = gPanel;
        this.canvas = canvas;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add(new Canvas2D());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MiniMapCanvas.this.createImage();
            }
        });
    }

    void createImage() {
        this.image = null;
        if (this.bufferFactory != null) {
            this.bufferFactory.killMe = true;
            this.bufferFactory.interrupt();
        }
        this.w = this.canvas.pX2 - this.canvas.pX1 + 1;
        this.bufferFactory = new BufferFactory(this.w, this.h);
        this.bufferFactory.start();
        this.repaint();
    }

    private void bufferAvailable(BufferedImage image) {
        this.image = image;
        this.repaint();
    }

    private void drawMap(Graphics2D g, boolean forBuffer, Boolean killMe) {
        int xE;
        int xS;
        double xScale = (double)(this.w - 1) / this.canvas.view.mapLength();
        if (forBuffer) {
            g.setColor(Color.lightGray);
            int y = 5;
            g.drawLine(0, y, this.w - 1, y);
            xS = 0;
            xE = this.canvas.view.markerCount();
        } else {
            g.setColor(Color.red);
            xS = this.canvas.pX1 / this.canvas.boxW;
            xE = xS + this.canvas.boxCountX;
            if (xE > this.canvas.boxTotalX) {
                xE = this.canvas.boxTotalX;
            }
        }
        for (int i = xS; i < xE; ++i) {
            Marker m = this.canvas.view.getMarker(i);
            int pos = (int)(m.getPosition() * xScale);
            int y1 = 2;
            int y2 = 8;
            g.drawLine(pos, y1, pos, y2);
        }
    }

    private class BufferFactory
    extends Thread {
        BufferedImage buffer;
        private boolean killMe = false;
        private int w;
        private int h;

        BufferFactory(int w, int h) {
            this.w = w;
            this.h = h;
        }

        @Override
        public void run() {
            this.setPriority(1);
            this.setName("MiniMapCanvas BufferFactory");
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.killMe || this.w == 0 || this.h == 0) {
                return;
            }
            try {
                this.buffer = new BufferedImage(this.w, this.h, 1);
                Graphics2D g2d = this.buffer.createGraphics();
                g2d.setColor(MiniMapCanvas.this.getBackground());
                g2d.fillRect(0, 0, this.w, this.h);
                MiniMapCanvas.this.drawMap(g2d, true, this.killMe);
                g2d.dispose();
                if (!this.killMe) {
                    MiniMapCanvas.this.bufferAvailable(this.buffer);
                }
            }
            catch (Exception e) {
                System.out.println("MiniMapCanvas: " + e);
                e.printStackTrace();
            }
        }
    }

    private class Canvas2D
    extends JPanel {
        Canvas2D() {
            this.setPreferredSize(new Dimension(0, MiniMapCanvas.this.h));
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D g = (Graphics2D)graphics;
            if (MiniMapCanvas.this.image == null) {
                return;
            }
            int xOffset = ((MiniMapCanvas)MiniMapCanvas.this).gPanel.traitCanvas.getPanelWidth() + ((MiniMapCanvas)MiniMapCanvas.this).gPanel.listPanel.getPanelWidth() + 1;
            g.translate(xOffset, 0);
            g.drawImage((Image)MiniMapCanvas.this.image, 0, 0, null);
            MiniMapCanvas.this.drawMap(g, false, true);
        }
    }
}

