/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.importer;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.dialog.importer.BrapiImportDialog;
import jhi.flapjack.gui.dialog.importer.IBrapiWizard;
import jhi.flapjack.io.brapi.BrapiClient;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;
import scri.commons.gui.TaskDialog;

class BrapiPassPanelNB
extends JPanel
implements ActionListener,
IBrapiWizard {
    private BrapiClient client;
    private BrapiImportDialog dialog;
    private boolean isAuthenticated = false;
    private JLabel connectionLabel;
    private JCheckBox jCheckBox1;
    private JPanel jPanel1;
    private JLabel passLabel;
    private JPasswordField password;
    private JCheckBox useAuthentication;
    private JLabel userLabel;
    private JTextField username;

    public BrapiPassPanelNB(BrapiClient client, BrapiImportDialog dialog) {
        this.client = client;
        this.dialog = dialog;
        this.initComponents();
        this.useAuthentication.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.useAuthentication) {
            boolean state = this.useAuthentication.isSelected();
            this.userLabel.setEnabled(state);
            this.passLabel.setEnabled(state);
            this.username.setEnabled(state);
            this.password.setEnabled(state);
        }
    }

    void saveOptions() {
        if (this.useAuthentication.isSelected()) {
            this.client.setUsername(this.username.getText());
            this.client.setPassword(new String(this.password.getPassword()));
        } else {
            this.client.setUsername(null);
            this.client.setPassword(null);
        }
    }

    void updateLabels() {
        Image img = this.client.getResource().getImage().getImage();
        img = img.getScaledInstance(48, 48, 4);
        this.connectionLabel.setIcon(new ImageIcon(img));
        this.connectionLabel.setText("Connecting to " + this.client.getResource().getName());
    }

    @Override
    public void onShow() {
        this.dialog.enableBack(true);
        this.dialog.enableNext(true);
    }

    @Override
    public void onNext() {
        if (!this.useAuthentication.isSelected()) {
            try {
                if (this.client.requiresAuthentication()) {
                    TaskDialog.error((String)RB.getString((String)"gui.dialog.importer.BrapiPassPanelNB.requiresAuth"), (String)RB.getString((String)"gui.text.ok"));
                }
            }
            catch (Exception e) {
                TaskDialog.error((String)RB.getString((String)"gui.dialog.importer.BrapiPassPanelNB.communicationError"), (String)RB.getString((String)"gui.text.ok"));
                e.printStackTrace();
            }
        } else if (this.authenticate()) {
            this.dialog.setScreen(this.dialog.getStudiesPanel());
        }
        this.dialog.getBNext().requestFocusInWindow();
    }

    @Override
    public void onBack() {
        this.dialog.setScreen(this.dialog.getDataPanel());
        this.dialog.getBBack().requestFocusInWindow();
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getCardName() {
        return "pass";
    }

    private boolean authenticate() {
        ProgressDialog pd = new ProgressDialog((ITrackableJob)new DataDownloader(), RB.getString((String)"gui.dialog.importer.BrapiPassPanelNB.title"), RB.getString((String)"gui.dialog.importer.BrapiPassPanelNB.message"), (Frame)Flapjack.winMain);
        if (pd.failed("gui.error")) {
            return false;
        }
        if (!this.isAuthenticated) {
            TaskDialog.error((String)RB.getString((String)"gui.dialog.importer.BrapiPassPanelNB.error"), (String)RB.getString((String)"gui.text.close"));
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.connectionLabel = new JLabel();
        this.userLabel = new JLabel();
        this.username = new JTextField();
        this.passLabel = new JLabel();
        this.password = new JPasswordField();
        this.useAuthentication = new JCheckBox();
        this.jCheckBox1 = new JCheckBox();
        this.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Authentication details (optional):"));
        this.connectionLabel.setText("Connecting to resource:");
        this.userLabel.setText("Username to connect as:");
        this.userLabel.setEnabled(false);
        this.username.setEnabled(false);
        this.passLabel.setText("Password:");
        this.passLabel.setEnabled(false);
        this.password.setEnabled(false);
        this.useAuthentication.setText("This resource requires me to authenticate with it:");
        this.useAuthentication.setOpaque(false);
        this.jCheckBox1.setText("Remember my credentials");
        this.jCheckBox1.setEnabled(false);
        this.jCheckBox1.setOpaque(false);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useAuthentication).addComponent(this.connectionLabel)).addGap(0, 221, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passLabel).addComponent(this.userLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox1).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.username).addComponent(this.password)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.connectionLabel).addGap(18, 18, 18).addComponent(this.useAuthentication).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.username, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passLabel).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBox1).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private class DataDownloader
    extends SimpleJob {
        private DataDownloader() {
        }

        public void runJob(int jobID) throws Exception {
            BrapiPassPanelNB.this.client.setUsername(BrapiPassPanelNB.this.username.getText());
            BrapiPassPanelNB.this.client.setPassword(new String(BrapiPassPanelNB.this.password.getPassword()));
            BrapiPassPanelNB.this.isAuthenticated = BrapiPassPanelNB.this.client.doAuthentication();
        }
    }
}

