/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jhi.flapjack.analysis.OptimizeProject;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Project;
import jhi.flapjack.data.XMLRoot;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.NavPanel;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.WinMainMenuBar;
import jhi.flapjack.gui.dialog.QuickExportDialog;
import jhi.flapjack.gui.dialog.importer.BrapiImportDialog;
import jhi.flapjack.gui.dialog.importer.DataSourceDialog;
import jhi.flapjack.gui.dialog.importer.ImportDialog;
import jhi.flapjack.gui.traits.TabPanel;
import jhi.flapjack.gui.visualization.DataOpenedAnimator;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.io.DataImporter;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.GraphImporter;
import jhi.flapjack.io.GraphImporterWiggle;
import jhi.flapjack.io.ProjectSerializer;
import jhi.flapjack.io.QTLImporter;
import jhi.flapjack.io.TraitImporter;
import jhi.flapjack.io.brapi.BrapiClient;
import jhi.flapjack.io.cmd.SplitProject;
import scri.commons.gui.ITrackableJob;
import scri.commons.gui.Install4j;
import scri.commons.gui.ProgressDialog;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;
import scri.commons.gui.TaskDialog;

public class MenuFile {
    private WinMain winMain;
    private WinMainMenuBar menubar;
    private NavPanel navPanel;
    private GenotypePanel gPanel;

    void setComponents(WinMain winMain, WinMainMenuBar menubar, NavPanel navPanel) {
        this.winMain = winMain;
        this.menubar = menubar;
        this.navPanel = navPanel;
        this.gPanel = navPanel.getGenotypePanel();
    }

    void fileNew() {
        Project project = this.winMain.getProject();
        if (!ProjectSerializer.okToContinue(project, false)) {
            return;
        }
        XMLRoot.reset();
        project = new Project();
        this.winMain.setTitle(RB.getString((String)"gui.WinMain.title") + " - " + Install4j.VERSION);
        this.gPanel.resetBufferedState(false);
        this.winMain.setProject(project);
        this.navPanel.setProject(project);
    }

    public void fileOpen(FlapjackFile file) {
        Project project = this.winMain.getProject();
        if (!ProjectSerializer.okToContinue(project, false)) {
            return;
        }
        FlapjackFile toOpen = ProjectSerializer.queryOpen(file);
        if (toOpen == null) {
            return;
        }
        this.gPanel.resetBufferedState(false);
        SaveLoadHandler handler = new SaveLoadHandler(null, toOpen);
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)handler, RB.format((String)"gui.MenuFile.loadTitle", (Object[])new Object[0]), RB.format((String)"gui.MenuFile.loading", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (dialog.getResult() == 0 && handler.isOK) {
            Project openedProject = handler.project;
            this.winMain.setProject(openedProject);
            this.navPanel.setProject(openedProject);
            this.menubar.createRecentMenu(openedProject.fjFile);
            new DataOpenedAnimator(this.gPanel);
            this.winMain.setTitle(openedProject.fjFile.getName() + " - " + RB.getString((String)"gui.WinMain.title") + " - " + Install4j.VERSION);
        } else {
            this.gPanel.resetBufferedState(true);
        }
    }

    public boolean fileSave(boolean saveAs) {
        Project project = this.winMain.getProject();
        if (!ProjectSerializer.querySave(project, saveAs)) {
            return false;
        }
        SaveLoadHandler handler = new SaveLoadHandler(project, null);
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)handler, RB.format((String)"gui.MenuFile.saveTitle", (Object[])new Object[0]), RB.format((String)"gui.MenuFile.saving", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (dialog.getResult() == 0 && handler.isOK) {
            Actions.projectSaved();
            this.menubar.createRecentMenu(project.fjFile);
            this.winMain.setTitle(project.fjFile.getName() + " - " + RB.getString((String)"gui.WinMain.title") + " - " + Install4j.VERSION);
            return true;
        }
        return false;
    }

    public void fileOptimize() {
        String msg = RB.getString((String)"gui.MenuFile.optimizeMsg");
        String[] options = new String[]{RB.getString((String)"gui.MenuFile.optimize"), RB.getString((String)"gui.text.cancel")};
        if (TaskDialog.show((String)msg, (int)3, (int)1, (String[])options) != 0) {
            return;
        }
        OptimizeProject optimize = new OptimizeProject();
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)optimize, RB.format((String)"gui.MenuFile.optimizeTitle", (Object[])new Object[0]), RB.format((String)"gui.MenuFile.optimizing", (Object[])new Object[0]), (Frame)Flapjack.winMain);
    }

    public void fileImportSelect() {
        DataSourceDialog dialog;
        boolean enableBrAPI = true;
        if (enableBrAPI && !(dialog = new DataSourceDialog()).isOK()) {
            return;
        }
        if (Prefs.guiImportType == 0 || !enableBrAPI) {
            this.fileImport(0);
        } else {
            this.fileBrapi();
        }
    }

    private void fileBrapi() {
        BrapiImportDialog dialog = new BrapiImportDialog();
        if (dialog.isOK()) {
            BrapiClient client = dialog.getBrapiClient();
            this.importGenotypeData(null, null, null, client, true);
        }
    }

    public void fileImport(int tabIndex) {
        boolean secondaryOptions = this.navPanel.getDataSetForSelection() != null;
        ImportDialog dialog = new ImportDialog(tabIndex, secondaryOptions);
        if (!dialog.isOK()) {
            return;
        }
        switch (dialog.getSelectedAction()) {
            case 0: {
                File hdf5File = dialog.getHDF5File();
                File mapFile = dialog.getMapFile();
                File genoFile = dialog.getGenotypeFile();
                this.importGenotypeData(mapFile, genoFile, hdf5File, null, true);
                break;
            }
            case 1: {
                this.importTraitData(dialog.getTraitsFile());
                break;
            }
            case 2: {
                this.importQTLData(dialog.getFeaturesFile());
                break;
            }
            case 3: {
                this.importGraphData(dialog.getGraphsFile());
                break;
            }
            case 4: {
                this.fileOpen(dialog.getSampleProject());
            }
        }
    }

    private void importGenotypeData(File mapFile, File datFile, File hdf5File, BrapiClient client, boolean usePrefs) {
        this.gPanel.resetBufferedState(false);
        DataImporter importer = null;
        switch (Prefs.guiImportType) {
            case 0: {
                importer = new DataImporter(mapFile, datFile, usePrefs);
                break;
            }
            case 1: {
                importer = new DataImporter(client, usePrefs);
                break;
            }
            case 2: {
                importer = new DataImporter(hdf5File, usePrefs);
            }
        }
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)importer, RB.format((String)"gui.MenuFile.import.title", (Object[])new Object[0]), RB.format((String)"gui.MenuFile.import.message", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        DataSet dataSet = importer.getDataSet();
        this.winMain.getProject().addDataSet(dataSet);
        this.navPanel.addDataSetNode(dataSet);
        new DataOpenedAnimator(this.gPanel);
        Actions.projectModified();
    }

    public void importTraitData(File file) {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        TabPanel ttp = this.navPanel.getTraitsPanel(dataSet, true);
        ttp.getTraitsTab(false).removeAllTraits();
        TraitImporter importer = new TraitImporter(file, dataSet);
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)importer, RB.format((String)"gui.MenuFile.importTraits.dialogTitle", (Object[])new Object[0]), RB.format((String)"gui.MenuFile.importTraits.dialogLabel", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        for (GTViewSet viewSet : dataSet.getViewSets()) {
            viewSet.assignTraits();
        }
        ttp.getTraitsTab(true).updateModel();
        Actions.projectModified();
        TaskDialog.info((String)RB.format((String)"gui.MenuFile.importTraits.success", (Object[])new Object[]{importer.getTraitsCount(), importer.getTraitsRead()}), (String)RB.getString((String)"gui.text.close"));
    }

    private void importQTLData(File file) {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        QTLImporter importer = new QTLImporter(file, dataSet);
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)importer, RB.format((String)"gui.MenuFile.importQTLs.dialogTitle", (Object[])new Object[0]), RB.format((String)"gui.MenuFile.importQTLs.dialogLabel", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        TabPanel ttp = this.navPanel.getTraitsPanel(dataSet, true);
        ttp.getQTLTab().updateModel();
        Actions.projectModified();
        TaskDialog.info((String)RB.format((String)"gui.MenuFile.importQTLs.success", (Object[])new Object[]{importer.getFeaturesRead(), importer.getFeaturesAdded()}), (String)RB.getString((String)"gui.text.close"));
    }

    private GraphImporter setupGraphImporter(File file, DataSet dataSet) {
        FlapjackFile f = new FlapjackFile(file.getAbsolutePath());
        if (!f.canDetermineType()) {
            return null;
        }
        GraphImporter gi = null;
        if (f.getType() == 8) {
            gi = new GraphImporter(file, dataSet);
        } else if (f.getType() == 9) {
            gi = new GraphImporterWiggle(file, dataSet);
        }
        return gi;
    }

    private void importGraphData(File file) {
        DataSet dataSet = this.navPanel.getDataSetForSelection();
        GraphImporter gi = this.setupGraphImporter(file, dataSet);
        if (gi == null) {
            return;
        }
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)gi, RB.format((String)"gui.MenuFile.importGraphs.dialogTitle", (Object[])new Object[0]), RB.format((String)"gui.MenuFile.importGraphs.dialogLabel", (Object[])new Object[0]), (Frame)Flapjack.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        for (GTViewSet viewSet : dataSet.getViewSets()) {
            viewSet.setGraphs(new int[]{0, -1, -1});
        }
        Actions.projectModified();
        this.gPanel.refreshView();
        int count = dataSet.getChromosomeMaps().get(0).getGraphs().size();
        TaskDialog.info((String)RB.format((String)"gui.MenuFile.importGraphs.success", (Object[])new Object[]{count}), (String)RB.getString((String)"gui.text.close"));
    }

    void handleDragDrop(String[] filenames) {
        System.out.println("Handle drag/drop");
        if (filenames[0].toLowerCase().endsWith(".fjzip")) {
            filenames = this.handleFJZipFile(filenames);
        }
        FlapjackFile[] files = new FlapjackFile[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            files[i] = new FlapjackFile(filenames[i]);
            System.out.println("Checking " + filenames[i]);
            files[i].canDetermineType();
        }
        for (FlapjackFile fjFile : files) {
            if (!fjFile.isProjectFile()) continue;
            this.fileOpen(fjFile);
            break;
        }
        FlapjackFile mapFile = null;
        FlapjackFile datFile = null;
        FlapjackFile hdf5File = null;
        for (FlapjackFile fjFile : files) {
            if (fjFile.getType() == 4 && mapFile == null) {
                mapFile = fjFile;
            }
            if (fjFile.getType() == 5 && datFile == null) {
                datFile = fjFile;
            }
            if (fjFile.getType() != 10 || hdf5File != null) continue;
            hdf5File = fjFile;
        }
        if (mapFile != null && datFile != null) {
            Prefs.guiImportType = 0;
            this.importGenotypeData(mapFile.getFile(), datFile.getFile(), null, null, true);
        } else if (hdf5File != null) {
            Prefs.guiImportType = 2;
            this.importGenotypeData(null, null, hdf5File.getFile(), null, true);
        }
        for (FlapjackFile fjFile : files) {
            if (fjFile.getType() == 6) {
                this.importTraitData(fjFile.getFile());
                continue;
            }
            if (fjFile.getType() == 7) {
                this.importQTLData(fjFile.getFile());
                continue;
            }
            if (fjFile.getType() == 8) {
                this.importGraphData(fjFile.getFile());
                continue;
            }
            if (fjFile.getType() != 9) continue;
            this.importGraphData(fjFile.getFile());
        }
    }

    private String[] handleFJZipFile(String[] filenames) {
        try {
            File dir = FlapjackUtils.getCacheDir();
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(filenames[0])));
            ZipEntry ze = zis.getNextEntry();
            ArrayList<String> files = new ArrayList<String>();
            while (ze != null) {
                int n;
                files.add(new File(dir, ze.getName()).toString());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(dir, ze.getName())));
                BufferedInputStream in = new BufferedInputStream(zis);
                byte[] b = new byte[4096];
                while ((n = in.read(b)) != -1) {
                    out.write(b, 0, n);
                }
                out.close();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            return files.toArray(new String[0]);
        }
        catch (Exception exception) {
            return filenames;
        }
    }

    void fileExport() {
        QuickExportDialog qeDialog = new QuickExportDialog();
        String outputDir = qeDialog.getOutputDir();
        if (!qeDialog.isOK()) {
            return;
        }
        SplitProject splitter = new SplitProject(this.winMain.getProject(), outputDir);
        ProgressDialog dialog = new ProgressDialog((ITrackableJob)splitter, RB.format((String)"gui.MenuFile.quickExport.dialogTitle", (Object[])new Object[0]), RB.format((String)"gui.MenuFile.quickExport.dialogLabel", (Object[])new Object[0]), (Frame)this.winMain);
        if (dialog.failed("gui.error")) {
            return;
        }
        TaskDialog.info((String)RB.format((String)"gui.MenuFile.quickExport.success", (Object[])new Object[]{outputDir}), (String)RB.getString((String)"gui.text.close"));
    }

    private static class SaveLoadHandler
    extends SimpleJob {
        Project project;
        FlapjackFile file;
        boolean isOK;

        SaveLoadHandler(Project project, FlapjackFile file) {
            this.project = project;
            this.file = file;
        }

        public void runJob(int index) throws Exception {
            if (this.project == null) {
                this.project = ProjectSerializer.open(this.file);
                if (this.project != null) {
                    this.isOK = true;
                }
            } else {
                this.isOK = ProjectSerializer.save(this.project);
            }
        }
    }
}

