/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import jhi.flapjack.data.FeatureGroup;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.QTL;
import jhi.flapjack.data.QTLInfo;

public class QTLTrackOptimiser {
    public ArrayList<ArrayList<FeatureGroup>> getTracks(int size, GTView view) {
        ArrayList<ArrayList<FeatureGroup>> tracks = new ArrayList<ArrayList<FeatureGroup>>();
        ArrayList<QTLInfo> QTLInfos = view.getQTLs();
        for (int i = 0; i < size; ++i) {
            tracks.add(new ArrayList());
        }
        for (QTLInfo qtlInfo : QTLInfos) {
            ArrayList<FeatureGroup> track;
            QTL qtl = qtlInfo.getQTL();
            if (!qtl.isVisible() || !qtl.isAllowed()) continue;
            for (int trackNum = size - 1; trackNum >= 0 && !this.addToTrack(track = tracks.get(trackNum), qtlInfo, trackNum == 0); --trackNum) {
            }
        }
        return tracks;
    }

    private boolean addToTrack(ArrayList<FeatureGroup> track, QTLInfo qtlInfo, boolean group) {
        if (track.size() == 0) {
            track.add(new FeatureGroup(qtlInfo));
            return true;
        }
        FeatureGroup prev = track.get(track.size() - 1);
        if (qtlInfo.min() > prev.getMax()) {
            track.add(new FeatureGroup(qtlInfo));
            return true;
        }
        if (group) {
            prev.addFeature(qtlInfo);
            return true;
        }
        return false;
    }
}

