/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import jhi.flapjack.data.AlleleState;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.StateTable;

public class OptimizeStateTable {
    private DataSet dataSet;
    private StateTable stateTable;

    public OptimizeStateTable(DataSet dataSet) {
        this.dataSet = dataSet;
        this.stateTable = dataSet.getStateTable();
    }

    public void collapseHomzEncodedAsHet() {
        for (int i = 1; i < this.stateTable.size(); ++i) {
            AlleleState s = this.stateTable.getAlleleState(i);
            if (!s.isHomzEncodedAsHet()) continue;
            s = new AlleleState(s.getState(0), "");
            this.stateTable.getStates().set(i, s);
        }
        this.optimize(true);
    }

    public void optimize(boolean compareHomzOnly) {
        for (int i = 1; i < this.stateTable.size(); ++i) {
            for (int j = i + 1; j < this.stateTable.size(); ++j) {
                AlleleState s1 = this.stateTable.getAlleleState(i);
                AlleleState s2 = this.stateTable.getAlleleState(j);
                if (!compareHomzOnly && !s1.matches(s2) || compareHomzOnly && !s1.isSameHomzAs(s2)) continue;
                System.out.println("Collapsing " + s1 + " and " + s2);
                this.collapse(i, j);
                for (int k = j; k < this.stateTable.size() - 1; ++k) {
                    this.collapse(k, k + 1);
                }
                this.stateTable.deleteState(j);
                --j;
            }
        }
    }

    private void collapse(int s1, int s2) {
        for (int i = 0; i < this.dataSet.countLines(); ++i) {
            Line line = this.dataSet.getLineByIndex(i);
            line.collapseStates(s1, s2);
        }
    }
}

