/*
 * Decompiled with CFR 0.152.
 */
package jhi.brapi.client;

import java.util.List;
import java.util.Optional;
import jhi.brapi.api.Status;

public class AsyncChecker {
    public static final String ASYNCID = "asyncid";
    public static final String ASYNCSTATUS = "asyncstatus";
    public static final String ASYNC_PENDING = "PENDING";
    public static final String ASYNC_INPROCESS = "INPROCESS";
    public static final String ASYNC_FINISHED = "FINISHED";
    public static final String ASYNC_FAILED = "FAILED";

    public static Status hasAsyncId(List<Status> statuses) {
        Status status = null;
        Optional<Status> asyncStatus = statuses.stream().filter(s -> s.getCode().equalsIgnoreCase(ASYNCID) || s.getCode().equalsIgnoreCase("asynchid")).findFirst();
        if (asyncStatus.isPresent()) {
            status = asyncStatus.get();
        }
        return status;
    }

    public static Status checkAsyncStatus(List<Status> statuses) {
        Status status = null;
        Optional<Status> asyncStatus = statuses.stream().filter(s -> s.getCode().equalsIgnoreCase(ASYNCSTATUS) || s.getCode().equalsIgnoreCase("asynchstatus")).findFirst();
        if (asyncStatus.isPresent()) {
            status = asyncStatus.get();
        }
        return status;
    }

    public static boolean callInProcess(Status status) {
        return status != null && status.getMessage().equalsIgnoreCase(ASYNC_INPROCESS) || status.getMessage().equalsIgnoreCase(ASYNC_PENDING);
    }

    public static boolean callFinished(Status status) {
        return status != null && status.getMessage().equals(ASYNC_FINISHED);
    }
}

