/*
 * Decompiled with CFR 0.152.
 */
package jhi.brapi.api.calls;

import java.util.ArrayList;
import java.util.List;

public class BrapiCall {
    private String call;
    private List<String> datatypes = new ArrayList<String>();
    private List<String> methods = new ArrayList<String>();

    public BrapiCall() {
    }

    public BrapiCall(String call) {
        this.call = call;
    }

    public BrapiCall addMethod(String method) {
        this.methods.add(method);
        return this;
    }

    public BrapiCall addDatatype(String dataType) {
        this.datatypes.add(dataType);
        return this;
    }

    public boolean hasDataType(String dataType) {
        return this.datatypes.stream().filter(d -> d.equalsIgnoreCase(dataType)).count() >= 1L;
    }

    public boolean hasMethod(String method) {
        return this.methods.stream().filter(d -> d.equalsIgnoreCase(method)).count() >= 1L;
    }

    public String getCall() {
        return this.call;
    }

    public void setCall(String call) {
        this.call = call;
    }

    public List<String> getDatatypes() {
        return this.datatypes;
    }

    public void setDatatypes(List<String> datatypes) {
        this.datatypes = datatypes;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public String toString() {
        return "BrapiCall{call='" + this.call + '\'' + '}';
    }
}

