/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jhi.flapjack.gui.visualization.ColCanvas;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.GraphCanvas;
import jhi.flapjack.gui.visualization.ListPanel;
import jhi.flapjack.gui.visualization.MapCanvas;
import jhi.flapjack.gui.visualization.MiniMapCanvas;
import jhi.flapjack.gui.visualization.QTLCanvas;
import jhi.flapjack.gui.visualization.RowCanvas;
import jhi.flapjack.gui.visualization.StatusPanelNB;
import jhi.flapjack.gui.visualization.TraitCanvas;

public class CanvasController
extends JPanel
implements ChangeListener {
    private GenotypePanel gPanel;
    GenotypeCanvas canvas;
    MapCanvas mapCanvas;
    private MiniMapCanvas miniMapCanvas;
    private RowCanvas rowCanvas;
    private ColCanvas colCanvas;
    private QTLCanvas qtlCanvas;
    GraphCanvas[] graphCanvas;
    TraitCanvas traitCanvas;
    ListPanel listPanel;
    StatusPanelNB statusPanel;
    private JScrollPane sp;
    private JScrollBar hBar;
    private JScrollBar vBar;
    private JViewport viewport;
    private boolean isClickZooming = false;
    private float gtCenterX;
    private float gtCenterY;

    CanvasController(GenotypePanel gPanel, JScrollPane sp) {
        this.gPanel = gPanel;
        this.sp = sp;
        this.canvas = gPanel.canvas;
        this.listPanel = gPanel.listPanel;
        this.mapCanvas = gPanel.mapCanvas;
        this.miniMapCanvas = gPanel.miniMapCanvas;
        this.qtlCanvas = gPanel.qtlCanvas;
        this.graphCanvas = gPanel.graphCanvas;
        this.statusPanel = gPanel.statusPanel;
        this.viewport = sp.getViewport();
        this.viewport.addChangeListener(this);
        this.hBar = sp.getHorizontalScrollBar();
        this.vBar = sp.getVerticalScrollBar();
    }

    JScrollBar getHBar() {
        return this.hBar;
    }

    JScrollBar getVBar() {
        return this.vBar;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.canvas.computeForRedraw(this.viewport.getExtentSize(), this.viewport.getViewPosition());
    }

    private void setScrollbarAdjustmentValues(int xIncrement, int yIncrement) {
        this.hBar.setUnitIncrement(xIncrement);
        this.hBar.setBlockIncrement(xIncrement);
        this.vBar.setUnitIncrement(yIncrement);
        this.vBar.setBlockIncrement(yIncrement);
    }

    void doZoom() {
        if (!this.isClickZooming) {
            this.gtCenterX = this.canvas.gtCenterX;
            this.gtCenterY = this.canvas.gtCenterY;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CanvasController.this.moveTo(Math.round(CanvasController.this.gtCenterY), Math.round(CanvasController.this.gtCenterX), true);
            }
        });
        this.computePanelSizes();
    }

    void clickZoom(MouseEvent e) {
        this.isClickZooming = true;
        this.gtCenterX = e.getX() / this.canvas.boxW;
        this.gtCenterY = e.getY() / this.canvas.boxH;
        int currentValue = this.gPanel.statusPanel.getZoomY();
        this.gPanel.statusPanel.setZoomY(currentValue + 6);
        this.isClickZooming = false;
    }

    void computePanelSizes() {
        int zoomX = this.statusPanel.getZoomX();
        int zoomY = this.statusPanel.getZoomY();
        try {
            this.listPanel.computeDimensions(zoomY);
        }
        catch (Exception e) {
            SwingUtilities.invokeLater(() -> this.listPanel.computeDimensions(zoomY));
        }
        this.canvas.setDimensions(zoomX, zoomY);
        this.setScrollbarAdjustmentValues(this.canvas.boxW, this.canvas.boxH);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CanvasController.this.mapCanvas.updateBuffer = true;
                for (int i = 0; i < CanvasController.this.graphCanvas.length; ++i) {
                    CanvasController.this.graphCanvas[i].updateBuffer = true;
                }
                CanvasController.this.qtlCanvas.updateCanvasSize(true);
                CanvasController.this.miniMapCanvas.createImage();
            }
        });
    }

    void moveToLater(final int rowIndex, final int colIndex, final boolean centre) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CanvasController.this.moveTo(rowIndex, colIndex, centre);
            }
        });
    }

    void moveTo(int lineIndex, int markerIndex, boolean centre) {
        int offset = 0;
        if (lineIndex != -1) {
            if (centre) {
                offset = this.canvas.boxCountY * this.canvas.boxH / 2 - this.canvas.boxH;
            }
            int y = lineIndex * this.canvas.boxH - offset;
            this.vBar.setValue(y);
        }
        if (markerIndex != -1) {
            if (centre) {
                offset = this.canvas.boxCountX * this.canvas.boxW / 2 - this.canvas.boxW;
            }
            int x = markerIndex * this.canvas.boxW - offset;
            this.hBar.setValue(x);
        }
    }

    void moveBy(int x, int y) {
        this.hBar.setValue(this.hBar.getValue() + x);
        this.vBar.setValue(this.vBar.getValue() + y);
    }

    public void pageLeft() {
        int jumpTo = this.canvas.pX1 / this.canvas.boxW - this.canvas.boxCountX;
        this.moveToLater(-1, jumpTo, false);
    }

    public void pageRight() {
        int jumpTo = this.canvas.pX2Max / this.canvas.boxW + 1;
        this.moveToLater(-1, jumpTo, false);
    }

    public long computeCanvasViewPortBufferInBytes() {
        return (long)this.viewport.getWidth() * (long)this.viewport.getHeight() * 3L;
    }
}

