/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.IOverlayRenderer;

public class DataOpenedAnimator
extends Thread
implements IOverlayRenderer {
    private GenotypeCanvas canvas;
    private int x;
    private int y;
    private int w;
    private int h;

    public DataOpenedAnimator(GenotypePanel gPanel) {
        this.canvas = gPanel.canvas;
        this.start();
    }

    @Override
    public void run() {
        this.canvas.overlays.addFirst(this);
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int w2 = (this.canvas.pX2 - this.canvas.pX1) / 2;
        int h2 = (this.canvas.pY2 - this.canvas.pY1) / 2;
        int stepX = w2 / 22;
        int stepY = h2 / 22;
        for (int i = 0; i < 45; ++i) {
            this.x = this.canvas.pX1 + w2 - i * stepX;
            this.y = this.canvas.pY1 + h2 - i * stepY;
            this.w = i * stepX * 2;
            this.h = i * stepY * 2;
            this.canvas.repaint();
            try {
                Thread.sleep(16L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.canvas.overlays.remove(this);
        this.canvas.repaint();
    }

    @Override
    public void render(Graphics2D g) {
        g.setColor(Prefs.visColorBackground);
        g.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        g.clip(new Ellipse2D.Float(this.x, this.y, this.w, this.h));
        g.drawImage((Image)this.canvas.imageViewPort, this.canvas.pX1, this.canvas.pY1, null);
    }
}

