/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.simmatrix;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.results.SimMatrix;
import scri.commons.gui.NumberFormatCellRenderer;

class SimMatrixTableModel
extends AbstractTableModel {
    private SimMatrix matrix;
    private ArrayList<LineInfo> lineInfos;
    private int colCount;
    static Random rnd = new Random();

    SimMatrixTableModel(SimMatrix matrix) {
        this.matrix = matrix;
        this.lineInfos = matrix.getLineInfos();
        this.colCount = matrix.size();
    }

    @Override
    public String getColumnName(int col) {
        return this.lineInfos.get(col).name();
    }

    @Override
    public int getColumnCount() {
        return this.colCount;
    }

    @Override
    public int getRowCount() {
        return this.matrix.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col <= row) {
            return Float.valueOf(this.matrix.valueAt(row, col));
        }
        return Float.valueOf(this.matrix.valueAt(col, row));
    }

    static TableCellRenderer getCellRenderer() {
        return new NumberFormatCellRenderer();
    }

    static class HeatMapRenderer
    extends DefaultTableCellRenderer {
        HeatMapRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            float f = ((Float)value).floatValue();
            int r = (int)(f * 255.0f);
            int g = (int)(f * 255.0f);
            int b = (int)(f * 255.0f);
            this.setBackground(new Color(r, g, b));
            return this;
        }
    }
}

