/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import jhi.flapjack.analysis.AnalysisSet;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.MarkerInfo;
import jhi.flapjack.data.QTLInfo;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.data.pedigree.PedManager;
import jhi.flapjack.data.results.MabcChrScore;
import jhi.flapjack.data.results.MabcQtlScore;
import jhi.flapjack.data.results.MabcResult;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;

public class MabcAnalysis
extends SimpleJob {
    private GTViewSet viewSet;
    private boolean[] selectedChromosomes;
    private HashMap<QTLInfo, QTLParams> qtlHash = new HashMap();
    private double maxMarkerCoverage;
    private int rpIndex = 0;
    private int dpIndex = 1;
    private boolean excludeAdditionalParents;
    private boolean simpleStats;
    private String name;

    public MabcAnalysis(GTViewSet viewSet, boolean[] selectedChromosomes, double maxMarkerCoverage, int rpIndex, int dpIndex, boolean excludeAdditionalParents, boolean simpleStats, String name) {
        this(viewSet, selectedChromosomes, maxMarkerCoverage, rpIndex, dpIndex, excludeAdditionalParents, simpleStats);
        this.name = name;
    }

    public MabcAnalysis(GTViewSet viewSet, boolean[] selectedChromosomes, double maxMarkerCoverage, int rpIndex, int dpIndex, boolean excludeAdditionalParents, boolean simpleStats) {
        this.viewSet = viewSet.createClone("", true);
        this.selectedChromosomes = selectedChromosomes;
        this.maxMarkerCoverage = maxMarkerCoverage;
        this.rpIndex = rpIndex;
        this.dpIndex = dpIndex;
        this.excludeAdditionalParents = excludeAdditionalParents;
        this.simpleStats = simpleStats;
        this.setupAnalysis();
    }

    private void setupAnalysis() {
        if (this.excludeAdditionalParents) {
            PedManager pedMan = this.viewSet.getDataSet().getPedManager();
            for (int i = this.viewSet.getLines().size() - 1; i >= 0; --i) {
                if (i == this.rpIndex || i == this.dpIndex || !pedMan.isParent(this.viewSet.getLines().get(i))) continue;
                this.viewSet.getLines().remove(i);
                if (i < this.rpIndex) {
                    --this.rpIndex;
                }
                if (i >= this.dpIndex) continue;
                --this.dpIndex;
            }
        }
    }

    public void runJob(int index) throws Exception {
        AnalysisSet as = new AnalysisSet(this.viewSet).withViews(this.selectedChromosomes).withSelectedLines().withSelectedMarkers();
        this.calculateRPP(as);
        this.calculateLinkageDrag(as);
        this.prepareForVisualization();
    }

    private int findLastUsableMarker(AnalysisSet as, int viewIndex, int lineIndex) throws Exception {
        for (int mrkIndex = as.markerCount(viewIndex) - 1; mrkIndex >= 0; --mrkIndex) {
            if (as.getState(viewIndex, lineIndex, mrkIndex) == 0) continue;
            return mrkIndex;
        }
        return -1;
    }

    private void calculateRPP(AnalysisSet as) throws Exception {
        StateTable st = this.viewSet.getDataSet().getStateTable();
        for (int lineIndex = 0; lineIndex < as.lineCount(); ++lineIndex) {
            LineInfo line = as.getLine(lineIndex);
            MabcResult stats = new MabcResult(line);
            line.getResults().setMabcResult(stats);
            line.getResults().setName(this.name);
            for (int viewIndex = 0; viewIndex < as.viewCount(); ++viewIndex) {
                MabcChrScore chrScore = new MabcChrScore();
                chrScore.view = as.getGTView(viewIndex);
                stats.getChrScores().add(chrScore);
                int prevMrkIndex = -1;
                int lastMrkIndex = this.findLastUsableMarker(as, viewIndex, lineIndex);
                for (int mrkIndex = 0; mrkIndex < as.markerCount(viewIndex); ++mrkIndex) {
                    MarkerInfo marker = as.getMarker(viewIndex, mrkIndex);
                    int state = as.getState(viewIndex, lineIndex, mrkIndex);
                    if (state == 0) continue;
                    int rp = as.getState(viewIndex, this.rpIndex, mrkIndex);
                    int dp = as.getState(viewIndex, this.dpIndex, mrkIndex);
                    if (rp == 0 || dp == 0 || rp == dp || st.isHet(rp) || st.isHet(dp)) continue;
                    double gap = 0.0;
                    double gapEnd = 0.0;
                    if (prevMrkIndex == -1) {
                        double pos = marker.position();
                        gap = Math.min(pos, this.maxMarkerCoverage);
                    } else if (mrkIndex < as.markerCount(viewIndex)) {
                        double pos1 = marker.position();
                        double prevPos = as.getMarker(viewIndex, prevMrkIndex).position();
                        gap = Math.min(pos1 - prevPos, this.maxMarkerCoverage);
                    }
                    if (mrkIndex == lastMrkIndex) {
                        double chrLength = as.mapLength(viewIndex);
                        double dist = chrLength - marker.position();
                        gapEnd = Math.min(dist, this.maxMarkerCoverage);
                    }
                    if (this.simpleStats) {
                        gap = 1.0;
                        gapEnd = 0.0;
                    }
                    chrScore.coverage += gap + gapEnd;
                    if (prevMrkIndex == -1) {
                        if (st.isHet(state)) {
                            chrScore.sumRP += gap / 2.0;
                            chrScore.sumDO += gap / 2.0;
                        } else if (state == rp) {
                            chrScore.sumRP += gap;
                        } else {
                            chrScore.sumDO += gap;
                        }
                    } else if (mrkIndex < as.markerCount(viewIndex)) {
                        if (st.isHet(state)) {
                            chrScore.sumRP += gap / 4.0;
                            chrScore.sumDO += gap / 4.0;
                        } else if (state == rp) {
                            chrScore.sumRP += gap / 2.0;
                        } else {
                            chrScore.sumDO += gap / 2.0;
                        }
                        int statePrev = as.getState(viewIndex, lineIndex, prevMrkIndex);
                        int pStatePrev = as.getState(viewIndex, this.rpIndex, prevMrkIndex);
                        if (st.isHet(statePrev)) {
                            chrScore.sumRP += gap / 4.0;
                            chrScore.sumDO += gap / 4.0;
                        } else if (statePrev == pStatePrev) {
                            chrScore.sumRP += gap / 2.0;
                        } else {
                            chrScore.sumDO += gap / 2.0;
                        }
                    }
                    if (mrkIndex == lastMrkIndex) {
                        if (st.isHet(state)) {
                            chrScore.sumRP += gapEnd / 2.0;
                            chrScore.sumDO += gapEnd / 2.0;
                        } else if (state == rp) {
                            chrScore.sumRP += gapEnd;
                        } else {
                            chrScore.sumDO += gapEnd;
                        }
                    }
                    prevMrkIndex = mrkIndex;
                }
                stats.updateAndAddGenomeCoverage(chrScore.coverage);
            }
            double genomeLength = 0.0;
            for (int viewIndex = 0; viewIndex < as.viewCount(); ++viewIndex) {
                genomeLength += as.mapLength(viewIndex);
            }
            double rppTotal = 0.0;
            for (int viewIndex = 0; viewIndex < as.viewCount(); ++viewIndex) {
                MabcChrScore chrScore = stats.getChrScores().get(viewIndex);
                rppTotal += chrScore.sumRP;
                chrScore.sumRP *= 1.0 / chrScore.coverage;
            }
            stats.setRppTotal(rppTotal *= 1.0 / stats.getGenomeCoverage());
            if (this.simpleStats) {
                stats.setGenomeCoverage(1.0);
                continue;
            }
            stats.setGenomeCoverage(stats.getGenomeCoverage() / genomeLength);
        }
    }

    private void calculateLinkageDrag(AnalysisSet as) {
        StateTable st = this.viewSet.getDataSet().getStateTable();
        for (int viewIndex = 0; viewIndex < as.viewCount(); ++viewIndex) {
            this.indexQTLs(as, viewIndex);
        }
        for (int lineIndex = 0; lineIndex < as.lineCount(); ++lineIndex) {
            LineInfo line = as.getLine(lineIndex);
            MabcResult stats = line.getResults().getMabcResult();
            for (int viewIndex = 0; viewIndex < as.viewCount(); ++viewIndex) {
                ArrayList<MarkerInfo> markers = as.getMarkers(viewIndex);
                for (QTLInfo qtlInfo : as.qtls(viewIndex)) {
                    int m;
                    QTLParams qtl = this.qtlHash.get(qtlInfo);
                    if (qtl == null) continue;
                    MabcQtlScore score = new MabcQtlScore(qtlInfo);
                    stats.getQtlScores().add(score);
                    for (m = qtl.LM; m >= 0 && (m <= 0 || as.getState(viewIndex, lineIndex, m - 1) != as.getState(viewIndex, this.rpIndex, m - 1)); --m) {
                        if (m == 0) {
                            score.drag += markers.get(m).position();
                            continue;
                        }
                        score.drag += markers.get(m).position() - markers.get(m - 1).position();
                    }
                    for (m = qtl.RM; m < markers.size() && (m > markers.size() - 2 || as.getState(viewIndex, lineIndex, m + 1) != as.getState(viewIndex, this.rpIndex, m + 1)); ++m) {
                        if (m == markers.size() - 1) {
                            score.drag += as.mapLength(viewIndex) - markers.get(m).position();
                            continue;
                        }
                        score.drag += markers.get(m + 1).position() - markers.get(m).position();
                    }
                    boolean isHomozygous = true;
                    boolean isQTLPresent = true;
                    for (int m2 = qtl.LM; m2 <= qtl.RM; ++m2) {
                        int allele = as.getState(viewIndex, lineIndex, m2);
                        int rp = as.getState(viewIndex, this.rpIndex, m2);
                        int dp = as.getState(viewIndex, this.dpIndex, m2);
                        if (qtl.isDP && dp == 0 || st.isHet(dp) || qtl.isRP && rp == 0 || st.isHet(rp)) continue;
                        if (dp == rp) {
                            if (allele == dp || allele == rp) continue;
                            isQTLPresent = false;
                            break;
                        }
                        if (allele != 0 && st.isHom(allele) && (qtl.isDP && allele == rp || qtl.isRP && allele == dp)) {
                            isQTLPresent = false;
                            break;
                        }
                        if (st.isHet(allele)) {
                            isHomozygous = false;
                            continue;
                        }
                        if (allele != 0 && (!qtl.isDP || allele != rp) && (!qtl.isRP || allele != dp)) continue;
                        isQTLPresent = false;
                        break;
                    }
                    score.status = isHomozygous && isQTLPresent ? 2 : (!isHomozygous && isQTLPresent ? 1 : 0);
                    stats.setQtlStatusCount(stats.getQtlStatusCount() + score.status);
                }
            }
        }
    }

    private void indexQTLs(AnalysisSet as, int viewIndex) {
        ArrayList<MarkerInfo> markers = as.getMarkers(viewIndex);
        for (QTLInfo qtl : as.qtls(viewIndex)) {
            QTLParams params = new QTLParams();
            String source = qtl.getQTL().valueOf("Source");
            if (source == null || !source.equalsIgnoreCase("DP") || !source.equalsIgnoreCase("DP") || !qtl.getQTL().isVisible()) continue;
            params.isDP = source.equalsIgnoreCase("DP");
            params.isRP = !params.isDP;
            double min = qtl.getQTL().getMin();
            double max = qtl.getQTL().getMax();
            for (int m = 0; m < markers.size(); ++m) {
                double pos = markers.get(m).position();
                if (pos >= min && params.LM == -1) {
                    params.LM = m;
                }
                if (pos >= min && pos <= max) {
                    params.RM = m;
                }
                if (pos > max) break;
            }
            if (params.LM == -1 || params.RM == -1) continue;
            this.qtlHash.put(qtl, params);
        }
    }

    private void prepareForVisualization() {
        this.prepareParentsForVisualization();
        this.changeColourScheme();
        this.addViewSetToDataSet();
    }

    private void prepareParentsForVisualization() {
        this.viewSet.getLines().get(this.rpIndex).getResults().setSortToTop(true);
        this.viewSet.getLines().get(this.dpIndex).getResults().setSortToTop(true);
        LineInfo rp = this.viewSet.getLines().get(this.rpIndex);
        LineInfo dp = this.viewSet.getLines().get(this.dpIndex);
        this.viewSet.getLines().remove(rp);
        this.viewSet.getLines().remove(dp);
        this.viewSet.getLines().add(0, rp);
        this.viewSet.getLines().add(1, dp);
    }

    private void changeColourScheme() {
        this.viewSet.setColorScheme(2);
        this.viewSet.setComparisonLineIndex(0);
        this.viewSet.setComparisonLine(this.viewSet.getLines().get(0).getLine());
    }

    private void addViewSetToDataSet() {
        DataSet dataSet = this.viewSet.getDataSet();
        int id = dataSet.getMabcCount() + 1;
        dataSet.setMabcCount(id);
        this.viewSet.setName(RB.format((String)"gui.MenuAnalysis.mabc.view", (Object[])new Object[]{id}));
        dataSet.getViewSets().add(this.viewSet);
    }

    public GTViewSet getViewSet() {
        return this.viewSet;
    }

    private static class QTLParams {
        int LM = -1;
        int RM = -1;
        boolean isDP;
        boolean isRP;

        private QTLParams() {
        }
    }
}

