/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5CompoundMemberInformation;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;

final class CompoundTypeInformation {
    final String name;
    final int compoundDataTypeId;
    final int nativeCompoundDataTypeId;
    private final HDF5CompoundMemberInformation[] members;
    final int[] dataTypeIds;
    final HDF5EnumerationType[] enumTypes;
    final int recordSizeOnDisk;
    final int recordSizeInMemory;
    private int numberOfVLMembers;

    CompoundTypeInformation(String name, int compoundDataTypeId, int nativeCompoundDataTypeId, int numberOfElements, int recordSizeOnDisk, int recordSizeInMemory) {
        this.name = name;
        this.compoundDataTypeId = compoundDataTypeId;
        this.nativeCompoundDataTypeId = nativeCompoundDataTypeId;
        this.members = new HDF5CompoundMemberInformation[numberOfElements];
        this.dataTypeIds = new int[numberOfElements];
        this.enumTypes = new HDF5EnumerationType[numberOfElements];
        this.recordSizeOnDisk = recordSizeOnDisk;
        this.recordSizeInMemory = recordSizeInMemory;
    }

    private void calcNumberOfVLMembers() {
        int countOfVLMembers = 0;
        HDF5CompoundMemberInformation[] hDF5CompoundMemberInformationArray = this.members;
        int n = this.members.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5CompoundMemberInformation m = hDF5CompoundMemberInformationArray[n2];
            if (m != null && m.getType().isVariableLengthString()) {
                ++countOfVLMembers;
            }
            ++n2;
        }
        this.numberOfVLMembers = countOfVLMembers;
    }

    int getNumberOfMembers() {
        return this.members.length;
    }

    HDF5CompoundMemberInformation getMember(int i) {
        return this.members[i];
    }

    HDF5CompoundMemberInformation[] getCopyOfMembers() {
        return (HDF5CompoundMemberInformation[])this.members.clone();
    }

    void setMember(int i, HDF5CompoundMemberInformation member) {
        this.members[i] = member;
        this.calcNumberOfVLMembers();
    }

    int getNumberOfVLMembers() {
        return this.numberOfVLMembers;
    }
}

