/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.pedver;

import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.results.PedVerF1sResult;
import jhi.flapjack.gui.Actions;
import jhi.flapjack.gui.table.LineDataTableModel;

public class PedVerF1sTableModel
extends LineDataTableModel {
    private static final int selectedIndex = 12;
    private static final int rankIndex = 13;
    private static final int commentIndex = 14;
    private static final int sortIndex = 15;

    public PedVerF1sTableModel(GTViewSet viewSet) {
        this.dataSet = viewSet.getDataSet();
        this.setLines(viewSet.tableHandler().linesForTable());
        this.initModel();
    }

    void initModel() {
        this.columnNames = new String[]{"Line", "Marker Count", "% Missing", "Het Count", "% Het", "% Deviation from Expected", "Count P1 Contained", "% P1 Contained", "Count P2 Contained", "% P2 Contained", "Count Allele Match to Expected", "% Allele Match to Expected", "Selected", "Rank", "Comments", "Don't Sort/Filter"};
        this.ttNames = new String[]{"Line", "Marker Count", "Percentage Missing", "Heterozygous Count", "Percentage Heterozygous", "Percentage Deviation from Expected", "Count of Parent 1 Contained", "Percentage of Parent 1 Contained", "Count of Parent 2 Contained", "Percentage of P2 Contained", "Count of Allele Match to Expected", "Percentage of Allele Match to Expected", "Selected", "Rank", "Comments", "Don't Sort/Filter"};
    }

    @Override
    public boolean skipExport(int col) {
        return col == 15;
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public Object getObjectAt(int row, int col) {
        LineInfo line = (LineInfo)this.lines.get(row);
        PedVerF1sResult stats = line.getResults().getPedVerF1sResult();
        if (col == 0) {
            return line;
        }
        if (col == 12) {
            return line.getSelected();
        }
        if (col == 15) {
            return line.getResults().isSortToTop();
        }
        if (col == 13) {
            return line.getResults().getRank();
        }
        if (stats == null) {
            return null;
        }
        switch (col) {
            case 1: {
                return stats.getMarkerCount();
            }
            case 2: {
                return stats.getPercentMissing();
            }
            case 3: {
                return stats.getHeterozygousCount();
            }
            case 4: {
                return stats.getPercentHeterozygous();
            }
            case 5: {
                return stats.getPercentDeviationFromExpected();
            }
            case 6: {
                return stats.getCountP1Contained();
            }
            case 7: {
                return stats.getPercentP1Contained();
            }
            case 8: {
                return stats.getCountP2Contained();
            }
            case 9: {
                return stats.getPercentP2Contained();
            }
            case 10: {
                return stats.getCountAlleleMatchExpected();
            }
            case 11: {
                return stats.getPercentAlleleMatchExpected();
            }
            case 14: {
                String comment = line.getResults().getComments();
                return comment == null ? "" : comment;
            }
        }
        return null;
    }

    @Override
    public Class getObjectColumnClass(int col) {
        if (col == 0) {
            return LineInfo.class;
        }
        if (col == 12 || col == 15) {
            return Boolean.class;
        }
        if (col == 14) {
            return String.class;
        }
        return Double.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 12 || col == 14 || col == 15;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        LineInfo line = (LineInfo)this.getObjectAt(row, 0);
        if (col == 12) {
            PedVerF1sTableModel.selectLine(line, (Boolean)value);
        } else if (col == 13) {
            line.getResults().setRank((Integer)value);
        } else if (col == 14) {
            line.getResults().setComments((String)value);
        } else if (col == 15) {
            line.getResults().setSortToTop((Boolean)value);
        }
        this.fireTableRowsUpdated(row, row);
        Actions.projectModified();
    }

    int getRankIndex() {
        return 13;
    }
}

