/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data.results;

import java.util.ArrayList;
import java.util.Arrays;
import jhi.flapjack.data.ISerializableDB;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.XMLRoot;
import scri.commons.gui.SystemUtils;

public class SimMatrix
extends XMLRoot
implements ISerializableDB {
    private String databaseID = SystemUtils.createGUID((int)8);
    private String title;
    private boolean isOrdered;
    private ArrayList<LineInfo> lineInfos = new ArrayList();
    private ArrayList<float[]> lineScores;

    public SimMatrix() {
    }

    private SimMatrix(ArrayList<LineInfo> lineInfos, ArrayList<float[]> lineScores) {
        this.lineInfos = lineInfos;
        this.lineScores = lineScores;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean getIsOrdered() {
        return this.isOrdered;
    }

    public void setIsOrdered(boolean isOrdered) {
        this.isOrdered = isOrdered;
    }

    public void setLineInfos(ArrayList<LineInfo> lineInfos) {
        this.lineInfos = lineInfos;
    }

    public ArrayList<LineInfo> getLineInfos() {
        return this.lineInfos;
    }

    public void setDatabaseID(String databaseID) {
        this.databaseID = databaseID;
    }

    @Override
    public String getDatabaseID() {
        return this.databaseID;
    }

    public void initialize(int size) {
        this.lineScores = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.lineScores.add(new float[i + 1]);
            Arrays.fill(this.lineScores.get(i), 1.0f);
        }
    }

    public float valueAt(int i, int j) {
        return this.lineScores.get(i)[j];
    }

    public void setValueAt(int i, int j, float value) {
        this.lineScores.get((int)i)[j] = value;
    }

    public int size() {
        return this.lineInfos.size();
    }

    public String createFileHeaderLine(boolean hasRowHeader) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lineInfos.size(); ++i) {
            sb.append("\t" + this.lineInfos.get(i).name());
        }
        if (hasRowHeader) {
            return "\t" + sb.toString().trim();
        }
        return sb.toString().trim();
    }

    public String createFileLine(int i, boolean hasRowHeader) {
        StringBuilder sb = new StringBuilder();
        if (hasRowHeader) {
            sb.append("\t" + this.lineInfos.get(i));
        }
        for (int j = 0; j < this.lineInfos.size(); ++j) {
            if (j <= i) {
                sb.append("\t" + this.valueAt(i, j));
                continue;
            }
            sb.append("\t" + this.valueAt(j, i));
        }
        return sb.toString().trim();
    }

    public SimMatrix cloneAndReorder(ArrayList<Integer> rIntOrder, ArrayList<LineInfo> newLineOrder) {
        int i;
        ArrayList<float[]> newScores = new ArrayList<float[]>(rIntOrder.size());
        for (i = 0; i < rIntOrder.size(); ++i) {
            newScores.add(new float[i + 1]);
            Arrays.fill((float[])newScores.get(i), 1.0f);
        }
        for (i = 0; i < this.lineScores.size(); ++i) {
            int x = rIntOrder.get(i);
            for (int j = 0; j <= i; ++j) {
                float score;
                int y = rIntOrder.get(j);
                newScores.get((int)i)[j] = score = x > y ? this.lineScores.get(x)[y] : this.lineScores.get(y)[x];
            }
        }
        SimMatrix newMatrix = new SimMatrix(newLineOrder, newScores);
        newMatrix.isOrdered = true;
        newMatrix.setTitle(this.title);
        return newMatrix;
    }

    @Override
    public Object dbGetObject() {
        return this.lineScores;
    }

    @Override
    public void dbSetObject(Object obj) {
        this.lineScores = (ArrayList)obj;
    }

    @Override
    public void dbClear() {
        this.lineScores.clear();
    }

    @Override
    public String dbGetType() {
        return "SimMatrix";
    }
}

