/*
 * Decompiled with CFR 0.152.
 */
package jhi.gobii;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jhi.gobii.GobiiHeader;
import jhi.gobii.Parent;
import jhi.gobii.SampleEntry;

public class HeaderCreator {
    private static final String PEDIGREE_HEADER = "# fjPedigree";
    private static final String WILDCARD = "*";
    private static final String SAMPLE_FILE_HEADER = "\tgermplasm_name";
    private File sample;
    private File output;
    private File genotype;
    private ArrayList<String> parentTypes = new ArrayList();
    private List<SampleEntry> sampleEntries = new ArrayList<SampleEntry>();

    public static void main(String[] args) {
        if (args.length == 3) {
            HeaderCreator creator = new HeaderCreator(new File(args[0]), new File(args[1]), new File(args[2]));
            try {
                creator.processSampleFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Usage: jhi.gobii.HeaderCreator input_file genotype_file output_file");
        }
    }

    public HeaderCreator(File sample, File genotype, File output) {
        this.sample = sample;
        this.genotype = genotype;
        this.output = output;
        this.initParentTypes();
    }

    private void initParentTypes() {
        this.parentTypes.add("RP");
        this.parentTypes.add("DP");
        this.parentTypes.add("N/A");
    }

    public void processSampleFile() throws Exception {
        if (this.sample == null || !this.sample.exists()) {
            throw new FileNotFoundException("Sample file not found");
        }
        if (this.genotype == null || !this.genotype.exists()) {
            throw new FileNotFoundException("Gentoype file not found");
        }
        this.parseSampleFile();
        this.writeOutputFile();
    }

    private void parseSampleFile() throws Exception {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.sample));){
            String fileLine;
            GobiiHeader gobiiHeader = null;
            while ((fileLine = reader.readLine()) != null) {
                if (fileLine.startsWith("# fj")) continue;
                if (fileLine.startsWith(SAMPLE_FILE_HEADER)) {
                    gobiiHeader = new GobiiHeader(fileLine.split("\t", -1));
                    gobiiHeader.validate();
                    continue;
                }
                String[] tokens = fileLine.split("\t", -1);
                String lineName = tokens[gobiiHeader.getColDnaRunName()];
                String germplasmName = tokens[gobiiHeader.getColGermplasmName()];
                String[] parentInfo = Arrays.copyOfRange(tokens, gobiiHeader.getColGermplasmPar1(), gobiiHeader.getColGermplasmPar4Type() + 1);
                HashSet<Parent> parents = this.parseParents(parentInfo);
                SampleEntry entry = new SampleEntry(lineName, germplasmName, parents);
                this.sampleEntries.add(entry);
            }
            for (SampleEntry entry : this.sampleEntries) {
                entry.getParents().removeIf(p -> this.getLinesForGermplasm(p.getGermplasmName()).isEmpty());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private HashSet<Parent> parseParents(String[] parentInfo) throws Exception {
        HashSet<Parent> parsed = new HashSet<Parent>();
        for (int i = 0; i < parentInfo.length; i += 2) {
            String parentName = parentInfo[i];
            if (parentName.isEmpty()) continue;
            Parent parent = new Parent(parentName, parentInfo[i + 1]);
            parsed.add(parent);
        }
        return parsed;
    }

    private void writeOutputFile() {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.genotype));
             PrintWriter writer = new PrintWriter(new FileWriter(this.output));){
            String genotypeLine = reader.readLine();
            while (genotypeLine.length() == 0 || genotypeLine.startsWith("#")) {
                writer.println(genotypeLine);
                genotypeLine = reader.readLine();
            }
            this.outputPedigreeHeader(writer);
            while (genotypeLine != null) {
                writer.println(genotypeLine);
                genotypeLine = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void outputPedigreeHeader(PrintWriter writer) throws Exception {
        if (this.sampleEntries.isEmpty()) {
            return;
        }
        for (String parentType : this.parentTypes) {
            if (this.isWildcardForType(parentType)) {
                String wildcardString = this.wildcardString(parentType);
                StringJoiner joiner = new StringJoiner("\t", "# fjPedigree\t", "");
                joiner.add(WILDCARD).add(parentType).add(wildcardString);
                if (wildcardString.isEmpty()) continue;
                writer.println(joiner.toString());
                continue;
            }
            for (SampleEntry entry : this.sampleEntries) {
                if (!entry.hasParentType(parentType)) continue;
                String parentString = this.linesForParentSet(entry.getParentsByType(parentType));
                StringJoiner joiner = new StringJoiner("\t", "# fjPedigree\t", "");
                joiner.add(entry.getDnaRunName()).add(parentType).add(parentString);
                if (parentString.isEmpty()) continue;
                writer.println(joiner.toString());
            }
        }
    }

    private boolean isWildcardForType(String parentType) {
        List parents = this.sampleEntries.stream().filter(s -> s.hasParentType(parentType)).map(s -> s.getParentsByType(parentType)).collect(Collectors.toCollection(ArrayList::new));
        if (parents.size() == 0) {
            return false;
        }
        if (parents.size() == 1) {
            return true;
        }
        Set comparisonSet = (Set)parents.get(0);
        return parents.stream().allMatch(Predicate.isEqual(comparisonSet));
    }

    private String wildcardString(String parentType) throws Exception {
        Optional<Set> parents = this.sampleEntries.stream().filter(s -> s.hasParentType(parentType)).map(s -> s.getParentsByType(parentType)).findFirst();
        if (parents.isPresent()) {
            Set found = parents.get();
            return found.stream().flatMap(p -> this.getLinesForGermplasm(p.getGermplasmName()).stream()).collect(Collectors.joining("\t"));
        }
        throw new Exception("An unexpected error occured while trying to generate a pedigree wildcard string.");
    }

    private String linesForParentSet(Set<Parent> parents) {
        return parents.stream().flatMap(p -> this.getLinesForGermplasm(p.getGermplasmName()).stream()).collect(Collectors.joining("\t"));
    }

    private List<String> getLinesForGermplasm(String germplasmName) {
        return this.sampleEntries.stream().filter(l -> l.getGermplasmName().equals(germplasmName)).map(SampleEntry::getDnaRunName).collect(Collectors.toCollection(ArrayList::new));
    }
}

