/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.table.CellData;
import jhi.flapjack.gui.table.LineDataTable;
import jhi.flapjack.gui.table.LineDataTableModel;
import jhi.flapjack.gui.table.LinkedColumnSelectionDialog;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.TablePanelTableModel;
import scri.commons.gui.RB;

class ListPanel
extends JPanel
implements MouseMotionListener,
MouseListener {
    private GTViewSet viewSet;
    private GTView view;
    private LineDataTable lineTable;
    private LineDataTableModel lineModel;
    private static Font font;
    private int rowUnderMouse = -1;
    private GenotypePanel genotypePanel;

    ListPanel(GenotypePanel genotypePanel) {
        this.genotypePanel = genotypePanel;
        this.createControls();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 0, 0));
        this.setBackground(Color.WHITE);
        this.add(this.lineTable);
        this.lineTable.addMouseMotionListener(this);
        this.lineTable.addMouseListener(this);
    }

    private void createControls() {
        this.lineModel = new TablePanelTableModel(this.viewSet);
        this.lineTable = new LineDataTable();
        this.lineTable.setAutoResizeMode(4);
        this.lineTable.setEnabled(false);
        this.lineTable.setDefaultRenderer(CellData.class, new HighlightTableCellRenderer());
        this.lineTable.setShowGrid(false);
        this.lineTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ListPanel.this.handlePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ListPanel.this.handlePopup(e);
            }
        });
        this.lineTable.setModel(this.lineModel);
    }

    int getPanelWidth() {
        return Prefs.visShowLinePanel ? this.getWidth() : 0;
    }

    void setView(GTView view) {
        this.view = view;
        this.viewSet = view.getViewSet();
        this.populateList();
    }

    private void populateList() {
        if (this.view == null) {
            return;
        }
        this.lineModel = new TablePanelTableModel(this.viewSet);
        this.lineTable.setModel(this.lineModel);
        if (font != null) {
            this.computeDimensions(font.getSize());
        }
    }

    void computeDimensions(int size) {
        font = new Font("Monospaced", 0, size);
        this.lineTable.setFont(font);
        if (this.lineTable.getGraphics() != null) {
            this.lineTable.setRowHeight(this.lineTable.getGraphics().getFontMetrics().getHeight());
        } else {
            this.lineTable.setRowHeight(this.lineTable.getFontMetrics(font).getHeight());
        }
        for (int col = 0; col < this.lineTable.getColumnCount(); ++col) {
            int width = 0;
            for (int row = 0; row < this.lineTable.getRowCount(); ++row) {
                TableCellRenderer renderer = this.lineTable.getCellRenderer(row, col);
                Component comp = this.lineTable.prepareRenderer(renderer, row, col);
                width = Math.max(comp.getPreferredSize().width + 1, width);
            }
            this.lineTable.getColumnModel().getColumn(col).setPreferredWidth(width);
        }
    }

    void moveLine(int fromIndex, int toIndex) {
        if (fromIndex >= this.lineModel.getRowCount() || toIndex >= this.lineModel.getRowCount()) {
            return;
        }
        LineInfo li = (LineInfo)this.lineModel.getObjectAt(fromIndex, 0);
        this.lineModel.setValueAt(this.lineModel.getObjectAt(toIndex, 0), fromIndex, 0);
        this.lineModel.setValueAt(li, toIndex, 0);
    }

    BufferedImage createSavableImage(boolean full, int yPos) {
        Dimension size = this.getPreferredSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Color background = this.lineTable.getBackground();
        this.lineTable.setBackground(Color.white);
        Graphics2D g = image.createGraphics();
        this.lineTable.setBackground(background);
        if (!full) {
            g.translate(0, -yPos);
        }
        this.paint(g);
        return image;
    }

    private void handlePopup(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        JPopupMenu menu = new JPopupMenu();
        JCheckBoxMenuItem mShowScores = new JCheckBoxMenuItem();
        RB.setText((AbstractButton)mShowScores, (String)"gui.visualization.ListPanel.showScores");
        mShowScores.setSelected(this.viewSet.getDisplayLineScores());
        mShowScores.addActionListener(event -> {
            this.viewSet.setDisplayLineScores(mShowScores.isSelected());
            this.populateList();
        });
        JCheckBoxMenuItem mShowTableResults = new JCheckBoxMenuItem();
        mShowTableResults.setText("Show table results");
        mShowTableResults.setSelected(this.viewSet.getLinkedModelCols().length > 0);
        mShowTableResults.setVisible(this.viewSet.tableHandler().model() != null);
        mShowTableResults.addActionListener(event -> {
            LinkedColumnSelectionDialog columnDialog = new LinkedColumnSelectionDialog(this.viewSet);
            if (columnDialog.isOK()) {
                this.populateList();
            }
        });
        menu.add(mShowScores);
        menu.add(mShowTableResults);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.rowUnderMouse = this.lineTable.rowAtPoint(e.getPoint());
        int colUnderMouse = this.lineTable.columnAtPoint(e.getPoint());
        this.lineTable.repaint();
        if (this.rowUnderMouse > 0) {
            String lineName = ((LineInfo)this.lineTable.getObjectAt(this.rowUnderMouse, 0)).name();
            if (colUnderMouse == 0 || colUnderMouse == 1) {
                this.genotypePanel.statusPanel.setResultsValues(lineName, null, null);
            } else {
                String columnName = this.lineTable.getColumnName(colUnderMouse) + ":";
                String value = this.lineTable.getObjectAt(this.rowUnderMouse, colUnderMouse).toString();
                this.genotypePanel.statusPanel.setResultsValues(lineName, columnName, value);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.rowUnderMouse = -1;
        this.lineTable.repaint();
        this.genotypePanel.statusPanel.setResultsValues(null, null, null);
        this.genotypePanel.statusPanel.setForMainUse();
    }

    public class HighlightTableCellRenderer
    extends DefaultTableCellRenderer {
        private final DecimalFormat df = new DecimalFormat("0.00");
        private final Color selectedBG = new Color(240, 240, 240);
        private final Color selectedFG = new Color(255, 0, 0);

        public HighlightTableCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            Object o = ((CellData)obj).getData();
            super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            if (o instanceof Number) {
                this.setText(this.df.format(o));
                this.setHorizontalAlignment(4);
            } else {
                this.setText(o.toString());
                this.setHorizontalAlignment(2);
            }
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            if (row == ((ListPanel)ListPanel.this).view.mouseOverLine || row == ListPanel.this.rowUnderMouse) {
                this.setBackground(this.selectedBG);
                this.setForeground(this.selectedFG);
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            if (!table.getColumnName(column).isEmpty()) {
                this.setToolTipText("<html><b>" + table.getColumnName(column) + "</b><br>" + this.getText() + "</html>");
            } else {
                this.setToolTipText(null);
            }
            return this;
        }
    }
}

