/*
 * Decompiled with CFR 0.152.
 */
package scri.commons.gui;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Random;

public abstract class SystemUtils {
    public static float jreVersion() {
        String jsv = System.getProperty("java.specification.version");
        return Float.parseFloat(jsv);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static boolean isWindowsVista() {
        return System.getProperty("os.name").startsWith("Windows Vista");
    }

    public static boolean isWindowsXP() {
        return System.getProperty("os.name").startsWith("Windows XP");
    }

    public static boolean isWindows7() {
        return System.getProperty("os.name").startsWith("Windows 7");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").startsWith("Linux");
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").startsWith("Mac OS");
    }

    public static long getFreeMemoryInBytes() {
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        return freeMemory + (maxMemory - allocatedMemory);
    }

    public static double getFreeMemoryInMB() {
        return (double)SystemUtils.getFreeMemoryInBytes() / 1024.0 / 1024.0;
    }

    public static String createGUID(int size) {
        String id = "";
        Random rnd = new Random();
        for (int i = 0; i < size; ++i) {
            int code = rnd.nextInt(16);
            id = code < 10 ? id + code : id + (char)(65 + (code - 10));
        }
        return id;
    }

    public static boolean isSCRIUser() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e != null & e.hasMoreElements()) {
                Enumeration<InetAddress> e2 = e.nextElement().getInetAddresses();
                while (e2.hasMoreElements()) {
                    String addr = e2.nextElement().getHostAddress();
                    if (!addr.startsWith("143.234.")) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isCurrentLinuxJava64Bit() {
        String osArch = System.getProperty("os.arch");
        return "64".equals(System.getProperty("sun.arch.data.model")) || "64".equals(System.getProperty("com.ibm.vm.bitmode")) || osArch.equals("ia64") || osArch.toLowerCase(Locale.ENGLISH).equals("ia64w") || osArch.equals("PA_RISC2.0W") || osArch.equals("amd64") || osArch.equals("sparcv9") || osArch.equals("x86_64") || osArch.equals("ppc64");
    }
}

