/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.cmd;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import jhi.flapjack.io.FlapjackFile;
import jhi.flapjack.io.cmd.CreateProject;
import scri.commons.io.FileUtils;

public class GobiiMabcConverter {
    private static File wrkDir;
    private static NumberFormat nf;
    private ArrayList<Marker> markers = new ArrayList();

    public static void main(String[] args) throws Exception {
        wrkDir = FileUtils.getTempUserDirectory((String)"jhi-flapjack");
        wrkDir = new File(wrkDir, "GobiiMabcConverter");
        wrkDir.mkdirs();
        GobiiMabcConverter converter = new GobiiMabcConverter();
        converter.createMap(new File(args[0]));
        converter.createGenotypes(new File(args[1]));
        converter.createQTL(new File(args[2]));
        CreateProject cp = new CreateProject(new File(wrkDir, "map"), new File(wrkDir, "geno"), null, new File(wrkDir, "qtl"), new FlapjackFile(args[3]), null, true);
        cp.doProjectCreation();
    }

    private void createMap(File inFile) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        String[] chrms = in.readLine().split(",");
        String[] mrkrs = in.readLine().split(",");
        in.close();
        BufferedWriter out = new BufferedWriter(new FileWriter(new File(wrkDir, "map")));
        out.write("# fjFile = MAP");
        out.newLine();
        for (int i = 0; i < chrms.length; ++i) {
            Marker m = new Marker(i, chrms[i], mrkrs[i]);
            this.markers.add(m);
            out.write(m.name + "\t" + m.chr + "\t" + m.pos);
            out.newLine();
        }
        out.close();
        this.markers.stream().forEach(marker -> System.out.println(marker.name));
    }

    private void createGenotypes(File inFile) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(new File(wrkDir, "geno")));
        out.write("# fjFile = GENOTYPE");
        out.newLine();
        in.readLine();
        in.readLine();
        for (Marker m : this.markers) {
            out.write("\t" + m.name);
        }
        out.newLine();
        int index = 0;
        String str = null;
        while ((str = in.readLine()) != null) {
            if (str.isEmpty()) continue;
            if (index == 0) {
                out.write("RP");
            } else if (index == 1) {
                out.write("DP");
            } else {
                out.write("RP[1]/DP-" + index);
            }
            for (String allele : str.split(",")) {
                out.write("\t" + allele);
            }
            out.newLine();
            ++index;
        }
        in.close();
        out.close();
    }

    private void createQTL(File inFile) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(inFile));
        BufferedWriter out = new BufferedWriter(new FileWriter(new File(wrkDir, "qtl")));
        out.write("# fjFile = QTL");
        out.newLine();
        out.write("Name\tChromosome\tPosition\tPos-Min\tPos-Max\tTrait\tExperiment\tSource");
        out.newLine();
        in.readLine();
        String str = null;
        while ((str = in.readLine()) != null) {
            if (str.isEmpty()) continue;
            String[] tokens = str.split(",");
            Marker lfm = this.markers.get(Integer.parseInt(tokens[1]) - 1);
            Marker rfm = this.markers.get(Integer.parseInt(tokens[2]) - 1);
            out.write(tokens[0] + "\t");
            out.write(lfm.chr + "\t");
            out.write(lfm.pos + (rfm.pos - lfm.pos) / 2.0f + "\t");
            out.write(lfm.pos + "\t");
            out.write(rfm.pos + "\t");
            out.write("TRAIT\tEXPERIMENT\t");
            out.write(tokens[3]);
            out.newLine();
        }
        in.close();
        out.close();
    }

    static {
        nf = NumberFormat.getInstance();
    }

    private static class Marker {
        String name;
        String chr;
        float pos;

        Marker(int index, String chr, String pos) throws Exception {
            this.name = "m" + (index + 1);
            this.chr = chr;
            this.pos = nf.parse(pos).floatValue();
        }
    }
}

