/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io.binning;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.NumberFormat;
import java.util.ArrayList;
import jhi.flapjack.io.binning.IBinner;

public class AutoBinner
implements IBinner {
    private int numBins = 10;
    private ArrayList<Integer> histogram;
    private ArrayList<Float> binSizes;
    private float[] binEnds;
    private NumberFormat nf = NumberFormat.getInstance();

    AutoBinner(int numBins, String histFile) throws Exception {
        this.numBins = numBins;
        this.readFile(histFile);
        this.setupBins(this.binSizes);
    }

    private void readFile(String histFile) throws Exception {
        this.binSizes = new ArrayList();
        this.histogram = new ArrayList();
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(histFile)));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("position")) continue;
                String[] tokens = line.split("\t");
                this.binSizes.add(Float.valueOf(this.nf.parse(tokens[0]).floatValue()));
                this.histogram.add(Integer.parseInt(tokens[1]));
            }
        }
    }

    private float[] setupBins(ArrayList<Float> binSizes) {
        int total = 0;
        for (Integer bin : this.histogram) {
            total += bin.intValue();
        }
        int cutoff = total / this.numBins;
        this.binEnds = new float[this.numBins];
        int binEnd = 0;
        int current = 0;
        for (int i = 0; i < this.histogram.size(); ++i) {
            if ((current += this.histogram.get(i).intValue()) < cutoff) continue;
            this.binEnds[binEnd] = binSizes.get(i).floatValue();
            ++binEnd;
            current = 0;
        }
        this.binEnds[this.numBins - 1] = 1.0f;
        return this.binEnds;
    }

    @Override
    public int bin(float value) {
        int bin = 0;
        while (this.binEnds[bin] < value) {
            ++bin;
        }
        return bin;
    }

    @Override
    public ArrayList<float[]> getBinSummary() {
        ArrayList<float[]> list = new ArrayList<float[]>();
        for (int i = 0; i < this.numBins; ++i) {
            float f1 = i == 0 ? 0.0f : this.binEnds[i - 1];
            float f2 = this.binEnds[i];
            list.add(new float[]{f1, f2});
        }
        return list;
    }
}

