/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.File;
import jhi.flapjack.analysis.OptimizeStateTable;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.StateTable;
import scri.commons.gui.RB;

public class PostImportOperations {
    private DataSet dataSet;

    public PostImportOperations(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public void collapseHomzEncodedAsHet() {
        OptimizeStateTable c = new OptimizeStateTable(this.dataSet);
        c.collapseHomzEncodedAsHet();
    }

    public void optimizeStateTable() {
        OptimizeStateTable c = new OptimizeStateTable(this.dataSet);
        c.optimize(false);
    }

    public void setName(File importFile) {
        if (importFile != null) {
            String name = importFile.getName();
            if (name.lastIndexOf(".") != -1) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            this.setName(name);
        } else {
            this.setName("BRAPI");
        }
    }

    public void setName(String name) {
        name = name + " " + this.dataSet.countLines() + "x" + this.dataSet.countGenuineMarkers();
        this.dataSet.setName(name);
    }

    public void createDefaultView() {
        String name = RB.getString((String)"gui.navpanel.VisualizationNode.defaultView");
        GTViewSet viewSet = new GTViewSet(this.dataSet, name);
        this.dataSet.getViewSets().add(viewSet);
        StateTable st = this.dataSet.getStateTable();
        int hCount = st.calculateHomozygousStateCount();
        if (st.containsNucleotides01()) {
            viewSet.setColorScheme(10);
        } else if (st.containsNucleotides()) {
            viewSet.setColorScheme(1);
        } else if (st.containsMagic()) {
            viewSet.setColorScheme(11);
        } else if (this.dataSet.getBinnedData().containsBins() || st.containsBins()) {
            viewSet.setColorScheme(9);
        } else if (this.dataSet.getStateTable().containsABHData()) {
            viewSet.setColorScheme(8);
        } else if (hCount > 0 && hCount < 10) {
            viewSet.setColorScheme(6);
        } else {
            viewSet.setColorScheme(50);
        }
    }
}

