/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.io;

import java.io.File;
import java.util.Collections;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.Marker;
import jhi.flapjack.io.GraphImporter;

public class GraphImporterWiggle
extends GraphImporter {
    public GraphImporterWiggle(File file, DataSet dataSet) {
        super(file, dataSet);
    }

    @Override
    protected void parseFile() throws Exception {
        String graphName = "";
        String chrom = "";
        while ((this.str = this.in.readLine()) != null && this.okToRun) {
            if (this.str.length() == 0 || this.str.startsWith("#")) continue;
            if (this.str.startsWith("track type=wiggle_0")) {
                graphName = this.parseName(this.str);
                continue;
            }
            if (this.str.startsWith("variableStep")) {
                chrom = this.parseChrom(this.str);
                continue;
            }
            this.addToGraph(chrom, graphName);
        }
    }

    private void addToGraph(String chrom, String graphName) throws Exception {
        String[] tokens = this.str.split(" ");
        if (tokens.length == 2) {
            double markerPos = this.nf.parse(tokens[0]).doubleValue();
            float value = this.nf.parse(tokens[1]).floatValue();
            String marker = this.getMarkerNameAtPosition(chrom, markerPos);
            if (graphName.length() > 0 && marker.length() > 0) {
                this.addToGraph(marker, graphName, value);
            }
        }
    }

    private String getMarkerNameAtPosition(String chrom, double pos) throws Exception {
        String markerName = "";
        for (ChromosomeMap m : this.dataSet.getChromosomeMaps()) {
            if (!m.getName().equals(chrom)) continue;
            int result = Collections.binarySearch(m.getMarkers(), new Marker("", pos));
            markerName = result != -1 ? m.getMarkerByIndex(result).getName() : "";
        }
        return markerName;
    }

    private String parseName(String str) {
        String[] vals;
        String name = "";
        for (String s : vals = str.split("\\s")) {
            if (!s.startsWith("name=")) continue;
            name = s.substring(s.indexOf(61) + 2, s.length() - 1);
        }
        return name;
    }

    private String parseChrom(String str) {
        String[] vals;
        String chrom = "";
        for (String s : vals = str.split("\\s")) {
            if (!s.startsWith("chrom=")) continue;
            chrom = s.substring(s.indexOf(61) + 1);
        }
        return chrom;
    }
}

