/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization.colors;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.StateTable;
import jhi.flapjack.gui.Prefs;
import scri.commons.gui.RB;

public abstract class ColorScheme {
    public static final int NUCLEOTIDE = 1;
    public static final int LINE_SIMILARITY = 2;
    public static final int MARKER_SIMILARITY = 4;
    public static final int SIMPLE_TWO_COLOR = 6;
    public static final int ALLELE_FREQUENCY = 7;
    public static final int ABH_DATA = 8;
    public static final int BINNED_10 = 9;
    public static final int NUCLEOTIDE01 = 10;
    public static final int MAGIC = 11;
    public static final int LINE_SIMILARITY_EXACT_MATCH = 12;
    public static final int RANDOM = 50;
    public static final int RANDOM_WSP = 51;
    protected GTView view;
    protected StateTable stateTable;

    ColorScheme() {
    }

    ColorScheme(GTView view) {
        this.view = view;
        this.stateTable = view.getViewSet().getDataSet().getStateTable();
    }

    public abstract BufferedImage getSelectedImage(int var1, int var2, boolean var3);

    public abstract BufferedImage getUnselectedImage(int var1, int var2, boolean var3);

    public abstract Color getColor(int var1, int var2);

    public abstract int getModel();

    public abstract ArrayList<ColorSummary> getColorSummaries();

    public abstract void setColorSummaries(ArrayList<ColorSummary> var1);

    public abstract String getDescription();

    public static ArrayList<ColorSummary> getStandardColorSummaries() {
        ArrayList<ColorSummary> colors = new ArrayList<ColorSummary>();
        colors.add(new ColorSummary(Prefs.visColorBackground, RB.getString((String)"gui.visualization.colors.ColorScheme.background")));
        colors.add(new ColorSummary(Prefs.visColorOverviewOutline, RB.getString((String)"gui.visualization.colors.ColorScheme.overviewOutline")));
        colors.add(new ColorSummary(Prefs.visColorOverviewFill, RB.getString((String)"gui.visualization.colors.ColorScheme.overviewFill")));
        colors.add(new ColorSummary(Prefs.visColorText, RB.getString((String)"gui.visualization.colors.ColorScheme.canvasText")));
        colors.add(new ColorSummary(Prefs.visColorHeatmapHigh, RB.getString((String)"gui.visualization.colors.ColorScheme.heatmapHigh")));
        colors.add(new ColorSummary(Prefs.visColorHeatmapLow, RB.getString((String)"gui.visualization.colors.ColorScheme.heatmapLow")));
        colors.add(new ColorSummary(Prefs.visColorHetsAsH, RB.getString((String)"gui.visualization.colors.ColorScheme.visColorHetsAsH")));
        return colors;
    }

    public static void setStandardColorSummaries(ArrayList<ColorSummary> colors) {
        Prefs.visColorBackground = colors.get((int)0).color;
        Prefs.visColorOverviewOutline = colors.get((int)1).color;
        Prefs.visColorOverviewFill = colors.get((int)2).color;
        Prefs.visColorText = colors.get((int)3).color;
        Prefs.visColorHeatmapHigh = colors.get((int)4).color;
        Prefs.visColorHeatmapLow = colors.get((int)5).color;
        Prefs.visColorHetsAsH = colors.get((int)6).color;
    }

    public static class ColorSummary {
        public Color color;
        public String name;

        ColorSummary(Color color, String name) {
            this.color = color;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

