/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.visualization;

import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import jhi.flapjack.gui.Prefs;
import jhi.flapjack.gui.WinMain;
import jhi.flapjack.gui.visualization.GenotypeCanvas;
import jhi.flapjack.gui.visualization.GenotypePanel;
import jhi.flapjack.gui.visualization.OverviewCanvas;
import jhi.flapjack.gui.visualization.OverviewDialog;
import jhi.flapjack.gui.visualization.OverviewPanel;

public class OverviewManager {
    private static OverviewCanvas dCanvas;
    private static OverviewCanvas pCanvas;
    private static OverviewDialog dialog;
    private static OverviewPanel panel;

    static void initialize(WinMain winMain, GenotypePanel gPanel, GenotypeCanvas genotypeCanvas) {
        dCanvas = new OverviewCanvas(gPanel, genotypeCanvas);
        pCanvas = new OverviewCanvas(gPanel, genotypeCanvas);
        dialog = new OverviewDialog(winMain, dCanvas);
        panel = new OverviewPanel();
        panel.setMinimumSize(new Dimension(0, 100));
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (Prefs.guiOverviewDialog) {
                    Prefs.guiOverviewDialog = false;
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
    }

    public static void setVisible(boolean visible) {
        if (visible) {
            dialog.setVisible(Prefs.guiOverviewDialog);
            panel.addCanvas(pCanvas);
        } else {
            dialog.setVisible(false);
            panel.removeCanvas();
        }
    }

    public static void toggleOverviewDialog() {
        Prefs.guiOverviewDialog = !Prefs.guiOverviewDialog;
        dialog.setVisible(Prefs.guiOverviewDialog);
    }

    public static OverviewPanel getPanel() {
        return panel;
    }

    static void createImage() {
        dCanvas.createImage();
        pCanvas.createImage();
    }

    static void updateOverviewSelectionBox(int xIndex, int xW, int yIndex, int yH) {
        dCanvas.updateOverviewSelectionBox(xIndex, xW, yIndex, yH);
        pCanvas.updateOverviewSelectionBox(xIndex, xW, yIndex, yH);
    }

    public static BufferedImage getExportableImage(int w, int h) {
        return pCanvas.exportImage(w, h);
    }
}

