/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.gui.dialog.analysis;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.gui.Flapjack;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.gui.dialog.analysis.SortLinesPanelNB;
import jhi.flapjack.gui.visualization.GenotypePanel;
import scri.commons.gui.RB;
import scri.commons.gui.matisse.DialogPanel;

public class SortLinesDialog
extends JDialog
implements ActionListener {
    JButton bOK;
    JButton bCancel;
    private boolean isOK = false;
    private GenotypePanel gPanel;
    private SortLinesPanelNB nbPanel;

    public SortLinesDialog(GenotypePanel gPanel) {
        super(Flapjack.winMain, RB.getString((String)"gui.dialog.analysis.SortLinesDialog.title"), true);
        this.gPanel = gPanel;
        this.nbPanel = new SortLinesPanelNB(this, gPanel.getViewSet());
        this.add(this.nbPanel);
        this.add((Component)this.createButtons(), "South");
        this.checkSelectedLine();
        FlapjackUtils.initDialog(this, this.bOK, this.bCancel, true, this.getContentPane());
    }

    private JPanel createButtons() {
        this.bOK = new JButton(RB.getString((String)"gui.text.ok"));
        this.bOK.addActionListener(this);
        this.bCancel = new JButton(RB.getString((String)"gui.text.cancel"));
        this.bCancel.addActionListener(this);
        DialogPanel p1 = new DialogPanel();
        p1.add(this.bOK);
        p1.add(this.bCancel);
        return p1;
    }

    private void checkSelectedLine() {
        int index = this.nbPanel.selectedLine.getSelectedIndex();
        GTView view = this.gPanel.getView();
        this.bOK.setEnabled(view.lineCount() > 0 && !view.isDummyLine(index) && !view.isSplitter(index));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.nbPanel.selectedLine) {
            this.checkSelectedLine();
        } else if (e.getSource() == this.bOK) {
            this.isOK = true;
            this.setVisible(false);
        } else if (e.getSource() == this.bCancel) {
            this.setVisible(false);
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public boolean[] getSelectedChromosomes() {
        return this.nbPanel.getSelectedChromosomes();
    }

    public Line getSelectedLine() {
        return ((LineInfo)this.nbPanel.selectedLine.getSelectedItem()).getLine();
    }
}

