/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import jhi.flapjack.analysis.SortLines;
import jhi.flapjack.data.GTView;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;

public class SortLinesExternally
extends SortLines {
    private File file;

    public SortLinesExternally(GTViewSet viewSet, File file) {
        super(viewSet);
        this.file = file;
    }

    @Override
    protected ArrayList<LineInfo> doSort(GTView view) {
        int numLines = view.lineCount();
        ArrayList<LineScore> scores = new ArrayList<LineScore>(numLines);
        for (int i = 0; i < numLines && this.okToRun; ++i) {
            scores.add(new LineScore(view.getLineInfo(i), numLines));
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.file));
            String str = null;
            int index = 1;
            block3: while ((str = in.readLine()) != null) {
                int i = 0;
                while (i < scores.size() && this.okToRun) {
                    if (((LineScore)scores.get((int)i)).lineInfo.getLine().getName().equals(str)) {
                        ((LineScore)scores.get((int)i)).index = index++;
                        continue block3;
                    }
                    ++i;
                    ++this.linesScored;
                }
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(scores);
        ArrayList<LineInfo> lineOrder = new ArrayList<LineInfo>(numLines);
        for (int i = 0; i < scores.size() && this.okToRun; ++i) {
            lineOrder.add(((LineScore)scores.get((int)i)).lineInfo);
        }
        return lineOrder;
    }

    private class LineScore
    implements Comparable<LineScore> {
        LineInfo lineInfo;
        int index;

        LineScore(LineInfo lineInfo, int index) {
            this.lineInfo = lineInfo;
            this.index = index;
        }

        @Override
        public int compareTo(LineScore other) {
            if (this.index < other.index) {
                return -1;
            }
            if (this.index == other.index) {
                return 0;
            }
            return 1;
        }
    }
}

