/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.awt.Desktop;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import jhi.flapjack.data.DBAssociation;
import jhi.flapjack.data.DataSet;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.Line;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.Trait;
import jhi.flapjack.data.TraitValue;
import jhi.flapjack.data.results.PCoAResult;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.gui.FlapjackUtils;
import jhi.flapjack.servlet.pcoa.PCoAClient;
import scri.commons.gui.RB;
import scri.commons.gui.SimpleJob;
import scri.commons.gui.SystemUtils;
import scri.commons.gui.TaskDialog;

public class PCoAGenerator
extends SimpleJob {
    private GTViewSet viewSet;
    private DataSet dataSet;
    private SimMatrix matrix;
    private String noDimensions;
    private PCoAClient client;
    private boolean callingCurlyWhirly = false;

    public PCoAGenerator(GTViewSet viewSet, SimMatrix matrix, String noDimensions) {
        this.viewSet = viewSet;
        this.matrix = matrix;
        this.noDimensions = noDimensions;
        this.dataSet = viewSet.getDataSet();
    }

    public String getMessage() {
        if (this.callingCurlyWhirly) {
            return RB.getString((String)"analysis.PCoAGenerator.cwMessage");
        }
        return null;
    }

    public void runJob(int index) throws Exception {
        this.client = new PCoAClient(this.matrix, this.noDimensions);
        PCoAResult result = this.client.generatePco();
        if (this.okToRun) {
            String GID = SystemUtils.createGUID((int)12);
            File pcoaFile = this.writePCoAFile(result, GID);
            File cwFile = this.writeCurlyWhirlyFile(pcoaFile, GID);
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.open(cwFile);
                    this.callingCurlyWhirly = true;
                    Thread.sleep(5000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TaskDialog.error((String)RB.format((String)"analysis.PCoAGenerator.cwError", (Object[])new Object[]{cwFile.getPath()}), (String)RB.getString((String)"gui.text.close"));
                }
            }
        }
    }

    private File writePCoAFile(PCoAResult result, String GID) throws Exception {
        int i;
        File pcoaFile = new File(FlapjackUtils.getCacheDir(), GID + ".txt");
        pcoaFile.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(pcoaFile));
        int[] selectedTraits = this.viewSet.getTraits();
        ArrayList<Trait> traits = this.dataSet.getTraits();
        ArrayList<LineInfo> lineInfos = result.getLineInfos();
        DBAssociation db = this.dataSet.getDbAssociation();
        if (db.isLineSearchEnabled()) {
            out.write("# cwDatabaseLineSearch=" + db.getLineSearch());
            out.newLine();
        }
        if (db.isGroupPreivewEnabled()) {
            out.write("# cwDatabaseGroupPreview=" + db.getGroupPreview());
            out.newLine();
        }
        if (db.isGroupUploadEnabled()) {
            out.write("# cwDatabaseGroupUpload=" + db.getGroupUpload());
            out.newLine();
        }
        if (db.isLineSearchEnabled() || db.isGroupPreivewEnabled() || db.isGroupUploadEnabled()) {
            out.newLine();
        }
        if (selectedTraits.length > 0) {
            for (int i2 = 0; i2 < selectedTraits.length; ++i2) {
                Trait trait = traits.get(selectedTraits[i2]);
                out.write("categories:" + trait.getName());
                out.write("\t");
            }
        } else {
            out.write("categories:\t");
        }
        out.write("label");
        int count = result.getData().get(0).length;
        for (i = 0; i < count; ++i) {
            out.write("\tP" + (i + 1));
        }
        out.newLine();
        for (i = 0; i < lineInfos.size(); ++i) {
            LineInfo lineInfo = lineInfos.get(i);
            Line line = lineInfo.getLine();
            if (selectedTraits.length > 0) {
                for (int t = 0; t < selectedTraits.length; ++t) {
                    TraitValue tv = line.getTraitValues().get(selectedTraits[t]);
                    out.write(tv.formatForCurlyWhirly());
                }
            } else {
                out.write("\t");
            }
            out.write(lineInfo.name());
            for (float data : result.getData().get(i)) {
                out.write("\t" + data);
            }
            out.newLine();
        }
        out.close();
        return pcoaFile;
    }

    private File writeCurlyWhirlyFile(File pcoaFile, String GID) throws Exception {
        File cwFile = new File(FlapjackUtils.getCacheDir(), GID + ".curlywhirly");
        cwFile.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(cwFile));
        out.write("<curlywhirly>");
        out.newLine();
        out.write("\t<datafile>" + pcoaFile.getPath() + "</datafile>");
        out.newLine();
        out.write("</curlywhirly>");
        out.close();
        return cwFile;
    }

    public void cancelJob() {
        super.cancelJob();
        this.client.cancelJob();
    }
}

