/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.analysis;

import java.util.ArrayList;
import jhi.flapjack.data.GTViewSet;
import jhi.flapjack.data.LineInfo;
import jhi.flapjack.data.results.Dendrogram;
import jhi.flapjack.data.results.SimMatrix;
import jhi.flapjack.io.ProjectSerializerDB;
import jhi.flapjack.servlet.dendrogram.DendrogramClient;
import scri.commons.gui.SimpleJob;

public class DendrogramGenerator
extends SimpleJob {
    private SimMatrix matrix;
    private SimMatrix orderedMatrix;
    private Dendrogram dendrogram;
    private GTViewSet newViewSet;
    private ArrayList<Integer> rIntOrder;
    private DendrogramClient client;

    public DendrogramGenerator(SimMatrix matrix, GTViewSet newViewSet) {
        this.matrix = matrix;
        this.newViewSet = newViewSet;
    }

    public Dendrogram getDendrogram() {
        return this.dendrogram;
    }

    public SimMatrix getOrderedMatrix() {
        return this.orderedMatrix;
    }

    public ArrayList<Integer> rIntOrder() {
        return this.rIntOrder;
    }

    public void runJob(int index) throws Exception {
        int lineCount = this.matrix.getLineInfos().size();
        this.client = new DendrogramClient(this.matrix, lineCount);
        this.dendrogram = this.client.generateDendrogram();
        if (this.okToRun) {
            this.rIntOrder = this.client.getLineOrder();
            ArrayList<LineInfo> order = new ArrayList<LineInfo>();
            for (int i = 0; i < this.rIntOrder.size(); ++i) {
                order.add(this.newViewSet.getLines().get(this.rIntOrder.get(i)));
            }
            this.dendrogram.setViewSet(this.newViewSet);
            ProjectSerializerDB.cacheToDisk(this.dendrogram.getPng());
            ProjectSerializerDB.cacheToDisk(this.dendrogram.getPdf());
            this.orderedMatrix = this.matrix.cloneAndReorder(this.rIntOrder, order);
            ProjectSerializerDB.cacheToDisk(this.orderedMatrix);
            this.newViewSet.setLines(order);
            this.newViewSet.getDendrograms().add(this.dendrogram);
            this.newViewSet.getMatrices().add(this.orderedMatrix);
        }
    }

    public void cancelJob() {
        super.cancelJob();
        new Thread(() -> this.client.cancelJob()).start();
    }
}

