/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.data;

import java.util.ArrayList;
import jhi.flapjack.data.ChromosomeMap;
import jhi.flapjack.data.GenotypeData;
import jhi.flapjack.data.TraitValue;
import jhi.flapjack.data.XMLRoot;

public class Line
extends XMLRoot {
    private String name;
    private ArrayList<GenotypeData> genotypes = new ArrayList();
    private ArrayList<TraitValue> traitValues = new ArrayList();

    public Line() {
    }

    public Line(String name) {
        this.name = new String(name);
    }

    void validate() throws NullPointerException {
        if (this.name == null) {
            throw new NullPointerException();
        }
        for (GenotypeData data : this.genotypes) {
            data.validate();
        }
        for (TraitValue traitValue : this.traitValues) {
            traitValue.validate();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList<GenotypeData> getGenotypes() {
        return this.genotypes;
    }

    public void setGenotypes(ArrayList<GenotypeData> genotypes) {
        this.genotypes = genotypes;
    }

    public ArrayList<TraitValue> getTraitValues() {
        return this.traitValues;
    }

    public void setTraitValues(ArrayList<TraitValue> traitValues) {
        this.traitValues = traitValues;
    }

    public String toString() {
        return this.name;
    }

    void initializeMap(ChromosomeMap map, boolean useByteStorage) {
        GenotypeData genoData = new GenotypeData(map, useByteStorage);
        this.genotypes.add(genoData);
    }

    boolean useByteStorage() {
        if (this.genotypes.size() > 0) {
            return this.genotypes.get(0).useByteStorage();
        }
        return true;
    }

    public void setLoci(int mapIndex, int lociIndex, int stateCode) {
        this.genotypes.get(mapIndex).setLoci(lociIndex, stateCode);
    }

    public void collapseStates(int s1, int s2) {
        for (GenotypeData data : this.genotypes) {
            data.collapseStates(s1, s2);
        }
    }

    public GenotypeData getGenotypeDataByMap(ChromosomeMap map) {
        for (GenotypeData data : this.genotypes) {
            if (!data.isGenotypeDataForMap(map)) continue;
            return data;
        }
        return null;
    }

    public int getState(int chromosome, int marker) {
        return this.genotypes.get(chromosome).getState(marker);
    }

    Line createDummy() {
        Line dummy = new Line(" ");
        for (GenotypeData data : this.genotypes) {
            dummy.initializeMap(data.getChromosomeMap(), true);
        }
        return dummy;
    }
}

