/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import jhi.flapjack.servlet.api.IScheduler;
import jhi.flapjack.servlet.api.StreamCatcher;

public class SLURMScheduler
implements IScheduler {
    private Logger LOG;

    @Override
    public void initialize() {
        this.LOG = Logger.getLogger(SLURMScheduler.class.getName());
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public String submit(String command, List<String> args, String wrkDir) throws Exception {
        this.LOG.info("Submitting a SLURM job...");
        for (String arg : args) {
            command = command + " " + arg;
        }
        File script = new File(wrkDir, "submit.sh");
        this.writeScript(command, script);
        ProcessBuilder pb = new ProcessBuilder("sbatch", "submit.sh");
        pb.directory(new File(wrkDir));
        pb.redirectErrorStream(true);
        this.LOG.info("Starting process");
        Process proc = pb.start();
        SBatchCatcher oStream = new SBatchCatcher(proc.getInputStream());
        this.LOG.info("Waiting for process");
        proc.waitFor();
        while (oStream.isAlive()) {
            Thread.sleep(10L);
        }
        this.LOG.info("Process finished");
        this.LOG.info("JOB ID IS: " + oStream.jobId);
        if (oStream.jobId != null) {
            return "" + oStream.jobId;
        }
        throw new Exception("Unable to submit job");
    }

    private void writeScript(String command, File script) throws IOException {
        String str;
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/src/arrr/Dendrogram.SLURM")));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(script)));
        while ((str = in.readLine()) != null) {
            str = str.replace("$COMMAND", command);
            out.println(str);
        }
        in.close();
        out.close();
    }

    @Override
    public boolean isJobFinished(String id) throws Exception {
        this.LOG.info("Querying SLURM job...");
        ProcessBuilder pb = new ProcessBuilder("squeue", "--jobs=" + id);
        pb.redirectErrorStream(true);
        this.LOG.info("Starting process");
        Process proc = pb.start();
        SQueueCatcher oStream = new SQueueCatcher(proc.getInputStream(), id);
        this.LOG.info("Waiting for process");
        proc.waitFor();
        while (oStream.isAlive()) {
            Thread.sleep(10L);
        }
        this.LOG.info("Process finished");
        this.LOG.info("JOB STATUS IS: " + oStream.status);
        if (oStream.status != null) {
            switch (oStream.status) {
                case "CF": 
                case "CG": 
                case "PD": 
                case " R": 
                case "ST": 
                case " S": {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void cancelJob(String id) throws Exception {
        ProcessBuilder pb = new ProcessBuilder("scancel", id);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        SCancelCatcher oStream = new SCancelCatcher(proc.getInputStream());
        proc.waitFor();
        while (oStream.isAlive()) {
            Thread.sleep(10L);
        }
        this.LOG.info("Cancelled job with ID " + id);
    }

    private class SCancelCatcher
    extends StreamCatcher {
        SCancelCatcher(InputStream in) {
            super(in);
        }

        @Override
        protected void processLine(String line) throws Exception {
            SLURMScheduler.this.LOG.info(line);
        }
    }

    private class SQueueCatcher
    extends StreamCatcher {
        String id;
        String status;

        SQueueCatcher(InputStream in, String id) {
            super(in);
            this.id = id;
        }

        @Override
        protected void processLine(String line) throws Exception {
            SLURMScheduler.this.LOG.info(line);
            if (line.trim().startsWith(this.id)) {
                this.status = line.substring(47, 49);
                SLURMScheduler.this.LOG.info("Parsed job status: " + this.status);
            }
        }
    }

    private class SBatchCatcher
    extends StreamCatcher {
        Integer jobId;

        SBatchCatcher(InputStream in) {
            super(in);
        }

        @Override
        protected void processLine(String line) throws Exception {
            SLURMScheduler.this.LOG.info(line);
            if (line.startsWith("Submitted batch job")) {
                String id = line.substring(20);
                this.jobId = Integer.parseInt(id);
                SLURMScheduler.this.LOG.info("Parsed job ID: " + this.jobId);
            }
        }
    }
}

