/*
 * Decompiled with CFR 0.152.
 */
package jhi.flapjack.servlet.api;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jhi.flapjack.servlet.api.IScheduler;
import jhi.flapjack.servlet.api.StreamCatcher;

public class ProcessScheduler
implements IScheduler {
    private Logger LOG;
    private AtomicInteger jobCount = new AtomicInteger(0);
    private ConcurrentHashMap<String, Process> jobs = new ConcurrentHashMap();

    @Override
    public void initialize() {
        this.LOG = Logger.getLogger(ProcessScheduler.class.getName());
    }

    @Override
    public void destroy() throws Exception {
    }

    @Override
    public String submit(final String command, final List<String> args, final String wrkDir) throws Exception {
        this.LOG.info("Submitting a ProcessBuilder job...");
        final String id = "" + this.jobCount.addAndGet(1);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    args.add(0, command);
                    ProcessBuilder pb = new ProcessBuilder(args);
                    pb.directory(new File(wrkDir));
                    ProcessScheduler.this.LOG.info("Starting process");
                    Process proc = pb.start();
                    ProcessScheduler.this.jobs.put(id, proc);
                    ProcessScheduler.this.LOG.info("Waiting for process");
                    File oFile = new File(wrkDir, command + ".o" + id);
                    SOutputCatcher oStream = new SOutputCatcher(proc.getInputStream(), oFile);
                    File eFile = new File(wrkDir, command + ".e" + id);
                    SOutputCatcher eStream = new SOutputCatcher(proc.getErrorStream(), eFile);
                    proc.waitFor();
                    oStream.close();
                    eStream.close();
                    ProcessScheduler.this.LOG.info("Process finished");
                }
                catch (Exception e) {
                    ProcessScheduler.this.LOG.log(Level.SEVERE, e.getMessage(), e);
                }
                ProcessScheduler.this.jobs.remove(id);
            }
        };
        new Thread(r).start();
        return id;
    }

    @Override
    public boolean isJobFinished(String id) throws Exception {
        Process proc = this.jobs.get(id);
        return proc == null || !proc.isAlive();
    }

    @Override
    public void cancelJob(String id) throws Exception {
        Process proc = this.jobs.get(id);
        if (proc != null && proc.isAlive()) {
            proc.destroy();
        }
        this.jobs.remove(id);
        this.LOG.info("Cancelled job with ID " + id);
    }

    private class SOutputCatcher
    extends StreamCatcher {
        PrintWriter out;

        SOutputCatcher(InputStream in, File oFile) throws IOException {
            super(in);
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(oFile)));
        }

        @Override
        protected void processLine(String line) throws Exception {
            this.out.println(line);
        }

        void close() throws Exception {
            this.out.close();
        }
    }
}

